/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.controller.request;

import java.util.Map;
import org.gatein.common.util.ParameterMap;
import org.gatein.pc.api.Mode;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.StateString;
import org.gatein.pc.api.WindowState;
import org.gatein.pc.api.invocation.ActionInvocation;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.api.spi.PortletInvocationContext;
import org.gatein.pc.controller.ControllerContext;
import org.gatein.pc.controller.request.PortletRequest;
import org.gatein.pc.controller.state.PageNavigationalState;
import org.gatein.pc.controller.state.WindowNavigationalState;

public class PortletActionRequest
extends PortletRequest {
    private final StateString interactionState;
    private final Map<String, String[]> bodyParameters;

    public PortletActionRequest(String windowId, StateString interactionState, Map<String, String[]> bodyParameters, WindowNavigationalState windowNavigationalState, PageNavigationalState pageNavigationalState) throws IllegalArgumentException {
        super(windowId, windowNavigationalState, pageNavigationalState);
        if (interactionState == null) {
            throw new IllegalArgumentException("No null interaction state accepted");
        }
        this.interactionState = interactionState;
        this.bodyParameters = bodyParameters;
    }

    public StateString getInteractionState() {
        return this.interactionState;
    }

    public Map<String, String[]> getBodyParameters() {
        return this.bodyParameters;
    }

    @Override
    public PortletInvocationResponse invoke(ControllerContext context) throws PortletInvokerException {
        WindowState windowState;
        Mode mode = this.windowNavigationalState.getMode();
        if (mode == null) {
            mode = Mode.VIEW;
        }
        if ((windowState = this.windowNavigationalState.getWindowState()) == null) {
            windowState = WindowState.NORMAL;
        }
        Map<String, String[]> publicNS = null;
        if (this.pageNavigationalState != null) {
            publicNS = context.getStateControllerContext().getPublicWindowNavigationalState(context, this.pageNavigationalState, this.windowId);
        }
        PortletInvocationContext portletInvocationContext = context.createPortletInvocationContext(this.windowId, this.pageNavigationalState);
        ActionInvocation actionInvocation = new ActionInvocation(portletInvocationContext);
        actionInvocation.setMode(mode);
        actionInvocation.setWindowState(windowState);
        actionInvocation.setNavigationalState(this.windowNavigationalState.getPortletNavigationalState());
        actionInvocation.setPublicNavigationalState(publicNS);
        actionInvocation.setInteractionState(this.interactionState);
        actionInvocation.setForm(this.bodyParameters != null ? ParameterMap.clone(this.bodyParameters) : null);
        return context.invoke(this.windowId, actionInvocation);
    }
}

