/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.embed;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.xml.namespace.QName;
import org.gatein.pc.api.Mode;
import org.gatein.pc.api.Portlet;
import org.gatein.pc.api.PortletInvoker;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.WindowState;
import org.gatein.pc.embed.Chunk;
import org.gatein.pc.embed.Segment;
import org.gatein.pc.embed.Window;

class Page {
    final Map<String, String[]> parameters;
    final LinkedHashMap<String, Window> windows;

    Page(PortletInvoker invoker, String s) throws ServletException {
        HashMap<String, Object> parameters;
        LinkedHashMap<String, Window> windows = new LinkedHashMap<String, Window>();
        int count = 0;
        if (s == null || s.length() == 0 || s.length() == 1 && s.charAt(0) == '/') {
            parameters = new HashMap<String, String[]>();
        } else {
            Segment segments = (Segment)Chunk.parse(s);
            segments = (Segment)segments.next;
            parameters = segments.parameters != null ? segments.parameters : new HashMap();
            for (Segment segment : (Segment)segments.next) {
                WindowState windowState;
                Mode windowMode;
                LinkedHashMap<String, String[]> windowParameters;
                Portlet found = null;
                if (invoker != null) {
                    try {
                        for (Portlet portlet : invoker.getPortlets()) {
                            if (!portlet.getInfo().getName().equals(segment.value)) continue;
                            found = portlet;
                            break;
                        }
                    }
                    catch (PortletInvokerException e) {
                        // empty catch block
                    }
                }
                if (segment.parameters != null) {
                    windowParameters = new LinkedHashMap<String, String[]>(segment.parameters);
                    String[] modeParameter = (String[])windowParameters.remove("javax.portlet.portlet_mode");
                    String[] windowStateParameter = (String[])windowParameters.remove("javax.portlet.window_state");
                    windowMode = modeParameter != null ? Mode.create((String)modeParameter[0]) : null;
                    windowState = windowStateParameter != null ? WindowState.create((String)windowStateParameter[0]) : null;
                } else {
                    windowParameters = null;
                    windowMode = null;
                    windowState = null;
                }
                Window context = new Window("" + count++, found, segment.value, windowMode, windowState, windowParameters);
                windows.put(context.id, context);
            }
        }
        this.windows = windows;
        this.parameters = parameters;
    }

    Collection<Window> getConsumers(QName wanted) {
        ArrayList<Window> consumers = null;
        for (Window window : this.windows.values()) {
            if (window.portlet == null) continue;
            for (QName name : window.portlet.getInfo().getEventing().getConsumedEvents().keySet()) {
                if (!wanted.equals(name)) continue;
                if (consumers == null) {
                    consumers = new ArrayList<Window>();
                }
                consumers.add(window);
            }
        }
        return consumers == null ? Collections.emptyList() : consumers;
    }
}

