/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.embed.htmlheader;

import java.net.URL;
import junit.framework.Assert;
import org.gatein.pc.embed.AbstractTestCase;
import org.gatein.pc.embed.htmlheader.HtmlHeaderPortlet;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Test;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class HtmlHeaderTestCase
extends AbstractTestCase {
    @Drone
    WebDriver driver;

    @Deployment
    public static WebArchive deployment() {
        return HtmlHeaderTestCase.deployment(HtmlHeaderPortlet.class);
    }

    @Test
    @RunAsClient
    public void testInteraction(@ArquillianResource URL deploymentURL) throws Exception {
        URL url = this.renderURL(deploymentURL, HtmlHeaderPortlet.class);
        this.driver.get(url.toString());
        WebElement title = this.driver.findElement(By.tagName((String)"title"));
        Assert.assertEquals((String)"_title_", (String)title.getText());
        WebElement script = this.driver.findElement(By.tagName((String)"script"));
        Assert.assertTrue((boolean)script.getAttribute("src").endsWith("_src_"));
        Assert.assertEquals((String)"_type_", (String)script.getAttribute("type"));
        WebElement link = this.driver.findElement(By.tagName((String)"link"));
        Assert.assertEquals((String)"_charset_", (String)link.getAttribute("charset"));
        Assert.assertTrue((boolean)link.getAttribute("href").endsWith("_href_"));
        Assert.assertEquals((String)"_media_", (String)link.getAttribute("media"));
        Assert.assertEquals((String)"_rel_", (String)link.getAttribute("rel"));
        Assert.assertEquals((String)"_type_", (String)link.getAttribute("type"));
        WebElement meta = this.driver.findElement(By.tagName((String)"meta"));
        Assert.assertEquals((String)"_name_", (String)meta.getAttribute("name"));
        Assert.assertEquals((String)"_http-equiv_", (String)meta.getAttribute("http-equiv"));
        Assert.assertEquals((String)"_content_", (String)meta.getAttribute("content"));
        WebElement style = this.driver.findElement(By.tagName((String)"style"));
        Assert.assertEquals((String)"_type_", (String)style.getAttribute("type"));
        Assert.assertEquals((String)"_media_", (String)style.getAttribute("media"));
        Assert.assertEquals((String)"_style_", (String)style.getText());
    }
}

