/*
 * Decompiled with CFR 0.152.
 */
package javax.portlet;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletSecurityException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;

public abstract class GenericPortlet
implements Portlet {
    private PortletConfig config;

    protected GenericPortlet() {
    }

    public void init() throws PortletException {
    }

    public PortletConfig getPortletConfig() {
        return this.config;
    }

    public String getPortletName() {
        return this.config.getPortletName();
    }

    public PortletContext getPortletContext() {
        return this.config.getPortletContext();
    }

    protected void doDispatch(RenderRequest request, RenderResponse response) throws PortletException, PortletSecurityException, IOException {
        if (!WindowState.MINIMIZED.equals(request.getWindowState())) {
            PortletMode portletMode = request.getPortletMode();
            if (PortletMode.VIEW.equals(portletMode)) {
                this.doView(request, response);
            } else if (PortletMode.HELP.equals(portletMode)) {
                this.doHelp(request, response);
            } else if (PortletMode.EDIT.equals(portletMode)) {
                this.doEdit(request, response);
            }
        }
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, PortletSecurityException, IOException {
        throw new PortletException();
    }

    protected void doHelp(RenderRequest request, RenderResponse response) throws PortletException, PortletSecurityException, IOException {
        throw new PortletException();
    }

    protected void doEdit(RenderRequest request, RenderResponse response) throws PortletException, PortletSecurityException, IOException {
        throw new PortletException();
    }

    public ResourceBundle getResourceBundle(Locale locale) {
        return this.getPortletConfig().getResourceBundle(locale);
    }

    protected String getTitle(RenderRequest request) {
        ResourceBundle bundle = this.getResourceBundle(request.getLocale());
        return bundle.getString("javax.portlet.title");
    }

    public String getInitParameter(String name) throws IllegalArgumentException {
        return this.getPortletConfig().getInitParameter(name);
    }

    public Enumeration getInitParameterNames() {
        return this.getPortletConfig().getInitParameterNames();
    }

    @Override
    public void init(PortletConfig config) throws PortletException {
        this.config = config;
        this.init();
    }

    @Override
    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, PortletSecurityException, IOException {
        throw new PortletException();
    }

    @Override
    public void render(RenderRequest request, RenderResponse response) throws PortletException, PortletSecurityException, IOException {
        response.setTitle(this.getTitle(request));
        this.doDispatch(request, response);
    }

    @Override
    public void destroy() {
    }
}

