/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.portlet.impl.jsr168;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import org.gatein.common.i18n.ResourceBundleFactory;
import org.gatein.common.reflect.NoSuchClassException;
import org.gatein.pc.portlet.impl.info.ContainerInfoBuilderContext;
import org.gatein.pc.portlet.impl.info.ResourceBundleManager;
import org.gatein.pc.portlet.impl.jsr168.SimpleResourceBundleFactory;
import org.gatein.pc.portlet.impl.metadata.PortletApplication10MetaData;
import org.gatein.pc.portlet.impl.metadata.PortletApplication20MetaData;
import org.gatein.pc.portlet.impl.metadata.portlet.PortletMetaData;

public class ContainerInfoBuilderContextImpl
implements ContainerInfoBuilderContext {
    private final PortletApplication10MetaData metaData;
    private final ServletContext webApp;
    private final Map<String, ResourceBundleManager> portletBundleMgrs;
    private ResourceBundleManager applicationBundleMgr;
    private final String applicationName;

    public ContainerInfoBuilderContextImpl(PortletApplication10MetaData metaData, ServletContext webApp) {
        this.metaData = metaData;
        this.webApp = webApp;
        this.portletBundleMgrs = new HashMap<String, ResourceBundleManager>();
        this.applicationName = webApp.getContextPath().substring(1);
    }

    @Override
    public String getApplicationName() {
        return this.applicationName;
    }

    @Override
    public ResourceBundleManager getBundleManager() {
        if (this.applicationBundleMgr == null) {
            String baseName = ((PortletApplication20MetaData)this.metaData).getResourceBundle();
            SimpleResourceBundleFactory rbf = new SimpleResourceBundleFactory(this.webApp.getClassLoader(), baseName);
            this.applicationBundleMgr = new ResourceBundleManager(null, rbf);
        }
        return this.applicationBundleMgr;
    }

    @Override
    public ResourceBundleManager getBundleManager(PortletMetaData portletMD) {
        ResourceBundleManager bundleMgr = this.portletBundleMgrs.get(portletMD.getPortletName());
        if (bundleMgr == null) {
            SimpleResourceBundleFactory rbf = null;
            String rbfName = this.metaData.getResourceBundleFactoryName();
            if (rbfName != null) {
                try {
                    Class<?> tmpClass = this.webApp.getClassLoader().loadClass(rbfName);
                    if (ResourceBundleFactory.class.isAssignableFrom(tmpClass)) {
                        Class<ResourceBundleFactory> rbfClass = tmpClass.asSubclass(ResourceBundleFactory.class);
                        Constructor<ResourceBundleFactory> rbfCtor = rbfClass.getConstructor(ClassLoader.class, String.class);
                        rbf = rbfCtor.newInstance(this.webApp.getClassLoader(), portletMD.getResourceBundle());
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (rbf == null) {
                rbf = new SimpleResourceBundleFactory(this.webApp.getClassLoader(), portletMD.getResourceBundle());
            }
            bundleMgr = new ResourceBundleManager(null, rbf);
            this.portletBundleMgrs.put(portletMD.getPortletName(), bundleMgr);
        }
        return bundleMgr;
    }

    @Override
    public Class getClass(String className) throws IllegalArgumentException, NoSuchClassException {
        if (className == null) {
            throw new IllegalArgumentException("No null class name accepted");
        }
        try {
            return this.webApp.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoSuchClassException(className, (Throwable)e);
        }
        catch (NoClassDefFoundError e) {
            throw new NoSuchClassException(className, (Throwable)e);
        }
    }
}

