/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.gatein.pc.portlet.state;

/**
 * @author <a href="mailto:julien@jboss.org">Julien Viet</a>
 * @version $Revision: 5776 $
 */
@SuppressWarnings("serial")
public class InvalidStateIdException extends Exception
{

   private String stateId;

   public InvalidStateIdException(String stateId)
   {
      super("No such state " + stateId);
      this.stateId = stateId;
   }

   public InvalidStateIdException(String message, String portletId)
   {
      super(message);
      this.stateId = portletId;
   }

   public InvalidStateIdException(Throwable cause, String portletId)
   {
      super(cause);
      this.stateId = portletId;
   }

   public InvalidStateIdException(String message, Throwable cause, String portletId)
   {
      super(message, cause);
      this.stateId = portletId;
   }

   public String getStateId()
   {
      return stateId;
   }
}
