/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.portlet.impl.jsr168;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.gatein.pc.portlet.impl.jsr168.Buffer;

public class CharBuffer
extends Buffer {
    private ClosableWriter chars;
    private PrintWriter writer;

    public String getChars() {
        if (this.chars == null) {
            return null;
        }
        return this.chars.writer.toString();
    }

    public PrintWriter getWriter() throws IllegalStateException {
        if (this.chars == null) {
            this.chars = new ClosableWriter(new StringWriter());
            this.writer = new PrintWriter(this.chars);
        }
        return this.writer;
    }

    @Override
    protected void doReset() {
        StringWriter sw = (StringWriter)this.chars.writer;
        sw.flush();
        sw.getBuffer().setLength(0);
    }

    private class ClosableWriter
    extends Writer {
        boolean closed = false;
        final Writer writer;

        public ClosableWriter(Writer writer) {
            this.writer = writer;
        }

        @Override
        public void write(int c) throws IOException {
            if (this.closed) {
                throw new IOException("Cannot write to a closed writer");
            }
            this.writer.write(c);
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            if (this.closed) {
                throw new IOException("Cannot write to a closed writer");
            }
            this.writer.write(cbuf, off, len);
        }

        @Override
        public void write(String str) throws IOException {
            if (this.closed) {
                throw new IOException("Cannot write to a closed writer");
            }
            this.writer.write(str);
        }

        @Override
        public void flush() throws IOException {
            if (this.closed) {
                throw new IOException("Cannot flush closed writer");
            }
            CharBuffer.this.commited = true;
        }

        @Override
        public void close() throws IOException {
            this.writer.close();
            CharBuffer.this.commited = true;
            this.closed = true;
        }
    }
}

