/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.portlet.deployment;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.gatein.pc.portlet.impl.deployment.staxnav.PortletApplicationMetaDataBuilder;
import org.gatein.pc.portlet.impl.metadata.PortletApplication20MetaData;
import org.xml.sax.SAXException;

public abstract class AbstractMetaDataTestCase
extends TestCase {
    protected PortletApplication20MetaData unmarshall(String file) throws SAXException, IOException {
        return this.unmarshall(file, false);
    }

    protected PortletApplication20MetaData unmarshall(String file, boolean fail) throws SAXException, IOException {
        try {
            PortletApplicationMetaDataBuilder builder = new PortletApplicationMetaDataBuilder();
            builder.setSchemaValidation(true);
            String path = this.getPath(file);
            URL url = new URL(path);
            InputStream in = url.openStream();
            AbstractMetaDataTestCase.assertNotNull((Object)in);
            PortletApplication20MetaData build = builder.build(in);
            if (fail) {
                throw new AssertionFailedError("Was expecting unmarshalling of " + file + " to fail");
            }
            return build;
        }
        catch (Exception e) {
            if (fail) {
                return null;
            }
            throw this.fail(e);
        }
    }

    protected final Error fail(Throwable t) {
        AssertionFailedError afe = new AssertionFailedError();
        afe.initCause(t);
        throw afe;
    }

    protected final Error fail(Throwable t, String msg) {
        AssertionFailedError afe = new AssertionFailedError(msg);
        afe.initCause(t);
        throw afe;
    }

    protected String getPath(String file) {
        URL url = Thread.currentThread().getContextClassLoader().getResource(file);
        if (url == null) {
            AbstractMetaDataTestCase.fail((String)(file + " not found."));
        }
        return url.toString();
    }

    protected InputStream getStream(String file) {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(file);
    }
}

