/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.samples.shoppingcart;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.portlet.Event;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletException;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.gatein.pc.samples.shoppingcart.CartEvent;
import org.gatein.pc.samples.shoppingcart.Catalog;
import org.gatein.pc.samples.shoppingcart.CatalogItem;

public class CartPortlet
extends GenericPortlet {
    public static final String ITEMS = "cart_items";

    protected void doView(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException, IOException {
        renderResponse.setContentType("text/html");
        PrintWriter writer = renderResponse.getWriter();
        List items = this.getItems(renderRequest.getPortletSession());
        if (!items.isEmpty()) {
            ((Writer)writer).append("<table width='95%' id=\"cart-table\"><thead><tr align='left'><th width='66%'>Description</th><th align='right'>Price</th></tr></thead><tbody>");
            int total = 0;
            for (CatalogItem item : items) {
                int price = item.getPrice();
                total += price;
                ((Writer)writer).append("<tr><td>").append(item.getDescription()).append("</td><td align='right'>$").append("" + price).append("</td></tr>");
            }
            ((Writer)writer).append("<tr><td><b>Total:</b></td><td align='right' style='border-top: 2px solid #000;'>").append("$" + total).append("</td></tr></tbody></table>");
        } else {
            ((Writer)writer).append("Cart is empty.");
        }
    }

    public void processEvent(EventRequest eventRequest, EventResponse eventResponse) throws PortletException, IOException {
        List items = this.getItems(eventRequest.getPortletSession());
        Event event = eventRequest.getEvent();
        if (event.getName().equals("CartEvent")) {
            CartEvent cartEvent = (CartEvent)event.getValue();
            items.add(Catalog.get((String)cartEvent.getId()));
        }
        eventRequest.getPortletSession().setAttribute(ITEMS, (Object)items);
    }

    private List<CatalogItem> getItems(PortletSession session) {
        ArrayList items = (ArrayList)session.getAttribute(ITEMS);
        if (items == null) {
            items = new ArrayList(7);
        }
        return items;
    }
}

