/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.api;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.gatein.api.AbstractApiTest;
import org.gatein.api.ApiException;
import org.gatein.api.Assert;
import org.gatein.api.EntityAlreadyExistsException;
import org.gatein.api.EntityNotFoundException;
import org.gatein.api.SerializationUtils;
import org.gatein.api.common.Attributes;
import org.gatein.api.common.Filter;
import org.gatein.api.common.Pagination;
import org.gatein.api.page.Page;
import org.gatein.api.page.PageId;
import org.gatein.api.page.PageQuery;
import org.gatein.api.security.Group;
import org.gatein.api.security.Membership;
import org.gatein.api.security.Permission;
import org.gatein.api.security.User;
import org.gatein.api.site.Site;
import org.gatein.api.site.SiteId;
import org.gatein.api.site.SiteQuery;
import org.gatein.api.site.SiteType;
import org.junit.Test;

public class PortalImplTest
extends AbstractApiTest {
    @Test
    public void createPage() {
        this.createSite(new SiteId("create-page"), new String[0]);
        Page page = this.portal.createPage(new PageId("create-page", "baz"));
        Assert.assertNotNull((Object)page);
        Assert.assertNull((Object)this.portal.getPage(new PageId("create-page", "baz")));
    }

    @Test(expected=ApiException.class)
    public void createPage_Faulty() {
        this.createSite(new SiteId("create-page-exists"), "bar");
        this.runWithFault(new Runnable(){

            @Override
            public void run() {
                PortalImplTest.this.portal.createPage(new PageId("create-page-exists", "bar"));
            }
        });
    }

    @Test(expected=IllegalArgumentException.class)
    public void createPage_NullPageId() {
        this.portal.createPage(null);
    }

    @Test(expected=EntityAlreadyExistsException.class)
    public void createPage_PageExists() {
        this.createSite(new SiteId("create-page-exists"), "bar");
        this.portal.createPage(new PageId("create-page-exists", "bar"));
    }

    @Test(expected=EntityNotFoundException.class)
    public void createPage_NoSite() {
        this.portal.createPage(new PageId("no-site", "baz"));
    }

    @Test
    public void createSite() {
        this.portal.createSite(new SiteId("newsite"), "basic");
        Assert.assertNull((Object)this.portal.getSite(new SiteId("newsite")));
    }

    @Test(expected=ApiException.class)
    public void createSite_Faulty() {
        this.runWithFault(new Runnable(){

            @Override
            public void run() {
                PortalImplTest.this.portal.createSite(new SiteId("newsite"), "basic");
            }
        });
    }

    @Test(expected=IllegalArgumentException.class)
    public void createSite_NullSiteId() {
        this.portal.createSite(null, "basic");
    }

    @Test(expected=IllegalArgumentException.class)
    public void createSite_NullTemplateName() {
        this.portal.createSite(new SiteId("newsite"), null);
    }

    @Test(expected=EntityAlreadyExistsException.class)
    public void createSite_SiteExists() {
        this.saveSite();
        this.portal.createSite(new SiteId("newsite"), "basic");
    }

    @Test
    public void findPages() {
        this.createSite(new SiteId("find-pages"), "page3", "page1", "page5", "page2", "page4");
        List pages = this.portal.findPages(new PageQuery.Builder().withSiteId(new SiteId("find-pages")).build());
        Assert.assertNotNull((Object)pages);
        Assert.assertEquals((long)5L, (long)pages.size());
    }

    @Test
    public void findPages_Filter() {
        this.createSite(new SiteId("find-pages"), "page3", "page1", "page5", "page2", "page4");
        Filter<Page> filter = new Filter<Page>(){

            public boolean accept(Page element) {
                return element.getName().equals("page1") || element.getName().equals("page4");
            }
        };
        List pages = this.portal.findPages(new PageQuery.Builder().withSiteId(new SiteId("find-pages")).withFilter((Filter)filter).build());
        Assert.assertNotNull((Object)pages);
        Assert.assertEquals((long)2L, (long)pages.size());
    }

    @Test
    public void findPages_BySiteName() {
        this.createSite(new SiteId("find-pages"), "page1", "page2");
        this.createSite(new SiteId(new Group("find-pages")), "page3");
        this.createSite(new SiteId(new User("find-pages")), "page4", "page5", "page6");
        PageQuery query = new PageQuery.Builder().withSiteName("find-pages").build();
        List pages = this.portal.findPages(query);
        Assert.assertEquals((long)6L, (long)pages.size());
    }

    @Test
    public void findPages_BySiteType() {
        this.createSite(new SiteId("find-pages"), "page1", "page2");
        this.createSite(new SiteId(new Group("find-pages")), "page3");
        this.createSite(new SiteId(new User("find-pages")), "page4", "page5", "page6");
        PageQuery query = new PageQuery.Builder().withSiteType(SiteType.SITE).build();
        List pages = this.portal.findPages(query);
        Assert.assertEquals((long)2L, (long)pages.size());
        query = new PageQuery.Builder().withSiteType(SiteType.SPACE).build();
        pages = this.portal.findPages(query);
        Assert.assertEquals((long)1L, (long)pages.size());
        query = new PageQuery.Builder().withSiteType(SiteType.DASHBOARD).build();
        pages = this.portal.findPages(query);
        Assert.assertEquals((long)3L, (long)pages.size());
    }

    @Test
    public void findPages_BySiteType_And_SiteName() {
        this.createSite(new SiteId("find-pages"), "page1", "page2");
        this.createSite(new SiteId(new Group("find-pages")), "find-pages", "page3");
        this.createSite(new SiteId(new User("find-pages")), "page4", "page5", "page6");
        PageQuery query = new PageQuery.Builder().withSiteType(SiteType.DASHBOARD).withSiteName("find-pages").build();
        List pages = this.portal.findPages(query);
        Assert.assertEquals((long)3L, (long)pages.size());
    }

    @Test
    public void findPages_ByTitle() {
        this.createSite(new SiteId("find-pages"), "page3", "page1", "page5", "page2", "page4");
        Page page = this.portal.getPage(new PageId("find-pages", "page1"));
        page.setDisplayName("FooTitle");
        this.portal.savePage(page);
        page = this.portal.getPage(new PageId("find-pages", "page4"));
        page.setDisplayName("FooTitle");
        this.portal.savePage(page);
        List pages = this.portal.findPages(new PageQuery.Builder().withSiteId(new SiteId("find-pages")).withDisplayName("FooTitle").build());
        Assert.assertEquals((long)2L, (long)pages.size());
        for (Page p : pages) {
            Assert.assertEquals((Object)"FooTitle", (Object)p.getDisplayName());
        }
    }

    @Test
    public void findPages_Pagination() {
        this.createSite(new SiteId("find-pages"), "page1", "page2", "page3", "page4", "page5", "page6", "page7");
        PageQuery query = new PageQuery.Builder().withSiteId(new SiteId("find-pages")).withPagination(0, 5).build();
        List pages = this.portal.findPages(query);
        Assert.assertEquals((long)5L, (long)pages.size());
        pages = this.portal.findPages(query.nextPage());
        Assert.assertEquals((long)2L, (long)pages.size());
    }

    @Test
    public void findSites() {
        this.createSite(this.defaultSiteId, new String[0]);
        List sites = this.portal.findSites(new SiteQuery.Builder().withAllSiteTypes().build());
        Assert.assertNotNull((Object)sites);
        Assert.assertEquals((long)1L, (long)sites.size());
        Assert.assertEquals((Object)"classic", (Object)((Site)sites.get(0)).getId().getName());
    }

    @Test
    public void findSites_Ascending() {
        this.createSite(new SiteId("z"), new String[0]);
        this.createSite(new SiteId("a"), new String[0]);
        this.createSite(new SiteId("f"), new String[0]);
        this.createSite(new SiteId("b"), new String[0]);
        List sites = this.portal.findSites(new SiteQuery.Builder().includeEmptySites(true).ascending().build());
        Assert.assertEquals((long)4L, (long)sites.size());
        Assert.assertEquals((Object)"a", (Object)((Site)sites.get(0)).getId().getName());
        Assert.assertEquals((Object)"b", (Object)((Site)sites.get(1)).getId().getName());
        Assert.assertEquals((Object)"f", (Object)((Site)sites.get(2)).getId().getName());
        Assert.assertEquals((Object)"z", (Object)((Site)sites.get(3)).getId().getName());
    }

    @Test(expected=ApiException.class)
    public void findSites_Faulty() {
        this.createSite(this.defaultSiteId, new String[0]);
        this.runWithFault(new Runnable(){

            @Override
            public void run() {
                PortalImplTest.this.portal.findSites(new SiteQuery.Builder().withAllSiteTypes().build());
            }
        });
    }

    @Test
    public void findSites_Filtered() {
        this.createSite(new SiteId("c"), new String[0]);
        this.createSite(new SiteId("a"), new String[0]);
        this.createSite(new SiteId("d"), new String[0]);
        this.createSite(new SiteId("b"), new String[0]);
        List sites = this.portal.findSites(new SiteQuery.Builder().includeEmptySites(true).withFilter((Filter)new Filter<Site>(){

            public boolean accept(Site site) {
                return site.getName().equals("a") || site.getName().equals("b");
            }
        }).build());
        Iterator iter = sites.iterator();
        Assert.assertEquals((long)2L, (long)sites.size());
        Site site = (Site)iter.next();
        Assert.assertEquals((Object)"a", (Object)site.getId().getName());
        site = (Site)iter.next();
        Assert.assertEquals((Object)"b", (Object)site.getId().getName());
    }

    @Test
    public void findSites_NaturalOrdering() {
        this.createSite(new SiteId("z"), new String[0]);
        this.createSite(new SiteId("a"), new String[0]);
        this.createSite(new SiteId("f"), new String[0]);
        this.createSite(new SiteId("b"), new String[0]);
        List sites = this.portal.findSites(new SiteQuery.Builder().includeEmptySites(true).build());
        Assert.assertEquals((long)4L, (long)sites.size());
        Assert.assertEquals((Object)"z", (Object)((Site)sites.get(0)).getId().getName());
        Assert.assertEquals((Object)"a", (Object)((Site)sites.get(1)).getId().getName());
        Assert.assertEquals((Object)"f", (Object)((Site)sites.get(2)).getId().getName());
        Assert.assertEquals((Object)"b", (Object)((Site)sites.get(3)).getId().getName());
    }

    @Test
    public void findSites_NonHidden() {
        this.createSite(new SiteId("test-site"), false, new String[0]);
        List sites = this.portal.findSites(new SiteQuery.Builder().withSiteTypes(SiteType.SITE, new SiteType[0]).build());
        Assert.assertTrue((boolean)sites.isEmpty());
    }

    @Test
    public void findSites_NonHidden_Paged() {
        for (int i = 0; i < 17; ++i) {
            this.createSite(new SiteId("site-" + i), i % 2 == 0, new String[0]);
        }
        List sites = this.portal.findSites(new SiteQuery.Builder().withSiteTypes(SiteType.SITE, new SiteType[0]).withPagination(0, 10).build());
        Assert.assertEquals((long)9L, (long)sites.size());
        for (int i = 0; i < 9; ++i) {
            Assert.assertEquals((Object)("site-" + i * 2), (Object)((Site)sites.get(i)).getName());
        }
    }

    @Test
    public void findSites_NoResults() {
        List sites = this.portal.findSites(new SiteQuery.Builder().withAllSiteTypes().build());
        Assert.assertNotNull((Object)sites);
        Assert.assertEquals((long)0L, (long)sites.size());
    }

    @Test(expected=IllegalArgumentException.class)
    public void findSites_NullQuery() {
        this.portal.findSites(null);
    }

    @Test
    public void findSites_Paged() {
        for (int i = 0; i < 10; ++i) {
            this.createSite(new SiteId("site" + (i + 1)), new String[0]);
        }
        SiteQuery query = new SiteQuery.Builder().includeEmptySites(true).withPagination(0, 5).build();
        List sites = this.portal.findSites(query);
        Assert.assertEquals((long)5L, (long)sites.size());
        Assert.assertEquals((Object)"site1", (Object)((Site)sites.get(0)).getName());
        Assert.assertEquals((Object)"site5", (Object)((Site)sites.get(4)).getName());
        query = query.nextPage();
        sites = this.portal.findSites(query);
        Assert.assertEquals((long)5L, (long)sites.size());
        Assert.assertEquals((Object)"site6", (Object)((Site)sites.get(0)).getName());
        Assert.assertEquals((Object)"site10", (Object)((Site)sites.get(4)).getName());
        query = query.nextPage();
        sites = this.portal.findSites(query);
        Assert.assertEquals((long)0L, (long)sites.size());
        query = query.previousPage();
        sites = this.portal.findSites(query);
        Assert.assertEquals((long)5L, (long)sites.size());
        query = new SiteQuery.Builder().from(query).withPagination(2, 5).withNextPage().build();
        sites = this.portal.findSites(query);
        Assert.assertEquals((long)3L, (long)sites.size());
        Assert.assertEquals((Object)"site8", (Object)((Site)sites.get(0)).getName());
        Assert.assertEquals((Object)"site10", (Object)((Site)sites.get(2)).getName());
    }

    @Test
    public void findSites_PagedWithMultipleSiteTypes() {
        this.createSite(new SiteId("site1"), new String[0]);
        this.createSite(new SiteId("site2"), new String[0]);
        this.createSite(new SiteId("site3"), new String[0]);
        this.createSite(new SiteId("site4"), new String[0]);
        this.createSite(new SiteId(new Group("/platform/users")), new String[0]);
        this.createSite(new SiteId(new Group("/foo/bar")), new String[0]);
        this.createSite(new SiteId(new Group("blah")), new String[0]);
        this.createSite(new SiteId(new User("root")), new String[0]);
        this.createSite(new SiteId(new User("john")), new String[0]);
        this.createSite(new SiteId(new User("mary")), new String[0]);
        List sites = this.portal.findSites(new SiteQuery.Builder().includeEmptySites(true).withAllSiteTypes().build());
        Assert.assertEquals((long)10L, (long)sites.size());
        Assert.assertEquals((long)10L, (long)this.portal.findSites(new SiteQuery.Builder().withAllSiteTypes().withPagination(0, 10).build()).size());
        Assert.assertEquals((long)5L, (long)this.portal.findSites(new SiteQuery.Builder().withAllSiteTypes().withPagination(0, 5).build()).size());
        Pagination pagination = new Pagination(0, 3);
        SiteQuery query = new SiteQuery.Builder().withAllSiteTypes().withPagination(pagination).build();
        Assert.assertEquals((long)3L, (long)this.portal.findSites(query).size());
        query = query.nextPage();
        Assert.assertEquals((long)3L, (long)this.portal.findSites(query).size());
        query = query.nextPage();
        Assert.assertEquals((long)3L, (long)this.portal.findSites(query).size());
        query = query.nextPage();
        Assert.assertEquals((long)1L, (long)this.portal.findSites(query).size());
        query = query.nextPage();
        Assert.assertEquals((long)0L, (long)this.portal.findSites(query).size());
        query = query.previousPage();
        Assert.assertEquals((long)1L, (long)this.portal.findSites(query).size());
        query = query.previousPage();
        Assert.assertEquals((long)3L, (long)this.portal.findSites(query).size());
        Assert.assertEquals((long)4L, (long)this.portal.findSites(new SiteQuery.Builder().includeEmptySites(true).withSiteTypes(SiteType.SITE, new SiteType[0]).build()).size());
        Assert.assertEquals((long)3L, (long)this.portal.findSites(new SiteQuery.Builder().includeEmptySites(true).withSiteTypes(SiteType.SPACE, new SiteType[0]).build()).size());
        Assert.assertEquals((long)3L, (long)this.portal.findSites(new SiteQuery.Builder().includeEmptySites(true).withSiteTypes(SiteType.DASHBOARD, new SiteType[0]).build()).size());
        Assert.assertEquals((long)2L, (long)this.portal.findSites(new SiteQuery.Builder().includeEmptySites(true).withSiteTypes(SiteType.SITE, new SiteType[0]).withPagination(0, 2).build()).size());
        Assert.assertEquals((long)2L, (long)this.portal.findSites(new SiteQuery.Builder().includeEmptySites(true).withSiteTypes(SiteType.SPACE, new SiteType[0]).withPagination(0, 2).build()).size());
        Assert.assertEquals((long)2L, (long)this.portal.findSites(new SiteQuery.Builder().includeEmptySites(true).withSiteTypes(SiteType.DASHBOARD, new SiteType[0]).withPagination(0, 2).build()).size());
        Assert.assertEquals((long)2L, (long)this.portal.findSites(new SiteQuery.Builder().includeEmptySites(true).withSiteTypes(SiteType.SITE, new SiteType[0]).withPagination(0, 2).withNextPage().build()).size());
        Assert.assertEquals((long)1L, (long)this.portal.findSites(new SiteQuery.Builder().includeEmptySites(true).withSiteTypes(SiteType.SPACE, new SiteType[0]).withPagination(0, 2).withNextPage().build()).size());
        Assert.assertEquals((long)1L, (long)this.portal.findSites(new SiteQuery.Builder().includeEmptySites(true).withSiteTypes(SiteType.DASHBOARD, new SiteType[0]).withPagination(0, 2).withNextPage().build()).size());
    }

    @Test
    public void findSites_Paged_NonZeroOffset() {
        for (int i = 0; i < 22; ++i) {
            this.createSite(new SiteId("site" + (i + 1)), new String[0]);
        }
        SiteQuery query = new SiteQuery.Builder().withPagination(11, 5).build();
        List sites = this.portal.findSites(query);
        Assert.assertEquals((long)5L, (long)sites.size());
        Assert.assertEquals((Object)"site12", (Object)((Site)sites.get(0)).getName());
        Assert.assertEquals((Object)"site16", (Object)((Site)sites.get(4)).getName());
    }

    @Test
    public void getPage() {
        this.createSite(new SiteId("get-page"), "bar");
        Assert.assertNotNull((Object)this.portal.getPage(new PageId("get-page", "bar")));
    }

    @Test(expected=ApiException.class)
    public void getPage_Faulty() {
        this.createSite(new SiteId("get-page"), "bar");
        this.runWithFault(new Runnable(){

            @Override
            public void run() {
                PortalImplTest.this.portal.getPage(new PageId("get-page", "bar"));
            }
        });
    }

    @Test
    public void getPage_NonExisting() {
        Assert.assertNull((Object)this.portal.getPage(new PageId("get-page", "blah")));
    }

    @Test(expected=IllegalArgumentException.class)
    public void getPage_Null() {
        this.portal.getPage(null);
    }

    @Test
    public void getSite() {
        this.createSite(this.defaultSiteId, new String[0]);
        Assert.assertNotNull((Object)this.portal.getSite(new SiteId("classic")));
    }

    @Test(expected=ApiException.class)
    public void getSite_Faulty() {
        this.createSite(this.defaultSiteId, new String[0]);
        this.runWithFault(new Runnable(){

            @Override
            public void run() {
                PortalImplTest.this.portal.getSite(new SiteId("classic"));
            }
        });
    }

    @Test
    public void getSite_Group() {
        this.createSite(new SiteId(new Group("/platform/something")), new String[0]);
        Site space = this.portal.getSite(new SiteId(new Group(new String[]{"platform", "something"})));
        Assert.assertNotNull((Object)space);
    }

    @Test
    public void getSite_NonExisting() {
        Assert.assertNull((Object)this.portal.getSite(new SiteId("nosuch")));
    }

    @Test(expected=IllegalArgumentException.class)
    public void getSite_NullSiteId() {
        this.portal.getSite(null);
    }

    @Test
    public void getSite_User() {
        this.createSite(new SiteId(new User("user10")), new String[0]);
        Site dashboard = this.portal.getSite(new SiteId(new User("user10")));
        Assert.assertNotNull((Object)dashboard);
    }

    @Test
    public void hasPermission() {
        this.createSite(new SiteId("permissions"), new String[0]);
        Page page = this.portal.createPage(new PageId("permissions", "page1"));
        page.setAccessPermission(Permission.everyone());
        page.setEditPermission(new Permission("*", new Group("/platform/administrators")));
        this.portal.savePage(page);
        page = this.portal.getPage(page.getId());
        Assert.assertTrue((boolean)this.portal.hasPermission(new User("root"), page.getAccessPermission()));
        Assert.assertTrue((boolean)this.portal.hasPermission(new User("root"), page.getEditPermission()));
        Assert.assertTrue((boolean)this.portal.hasPermission(User.anonymous(), page.getAccessPermission()));
        Assert.assertFalse((boolean)this.portal.hasPermission(User.anonymous(), page.getEditPermission()));
    }

    @Test
    public void hasMultiplePermission() {
        this.createSite(new SiteId("permissions"), new String[0]);
        Page page = this.portal.createPage(new PageId("permissions", "page1"));
        LinkedHashSet<Membership> memberships = new LinkedHashSet<Membership>(2);
        memberships.add(new Membership("*", new Group("/platform/administrators")));
        memberships.add(new Membership("*", new Group("/platform/users")));
        page.setAccessPermission(new Permission(memberships));
        page.setEditPermission(new Permission("*", new Group("/platform/administrators")));
        this.portal.savePage(page);
        page = this.portal.getPage(page.getId());
        Assert.assertTrue((boolean)this.portal.hasPermission(new User("root"), page.getAccessPermission()));
        Assert.assertTrue((boolean)this.portal.hasPermission(new User("root"), page.getEditPermission()));
        Assert.assertFalse((boolean)this.portal.hasPermission(User.anonymous(), page.getAccessPermission()));
        Assert.assertFalse((boolean)this.portal.hasPermission(User.anonymous(), page.getEditPermission()));
        Assert.assertTrue((boolean)this.portal.hasPermission(new User("john"), page.getAccessPermission()));
        Assert.assertFalse((boolean)this.portal.hasPermission(new User("john"), page.getEditPermission()));
    }

    @Test
    public void hasPermission_User() {
        this.createSite(new SiteId("permissions"), new String[0]);
        Page page = this.portal.createPage(new PageId("permissions", "page1"));
        page.setAccessPermission(new Permission(new User("root")));
        this.portal.savePage(page);
        Assert.assertTrue((boolean)this.portal.hasPermission(new User("root"), page.getAccessPermission()));
        Assert.assertFalse((boolean)this.portal.hasPermission(new User("john"), page.getAccessPermission()));
    }

    @Test
    public void removePage() {
        this.createSite(new SiteId("removePage"), "page1", "page2");
        Assert.assertNotNull((Object)this.portal.getPage(new PageId("removePage", "page1")));
        Assert.assertNotNull((Object)this.portal.getPage(new PageId("removePage", "page2")));
        Assert.assertTrue((boolean)this.portal.removePage(new PageId("removePage", "page1")));
        Assert.assertNull((Object)this.portal.getPage(new PageId("removePage", "page1")));
        Assert.assertNotNull((Object)this.portal.getPage(new PageId("removePage", "page2")));
        Assert.assertTrue((boolean)this.portal.removePage(new PageId("removePage", "page2")));
        Assert.assertNull((Object)this.portal.getPage(new PageId("removePage", "page1")));
        Assert.assertNull((Object)this.portal.getPage(new PageId("removePage", "page2")));
    }

    @Test(expected=ApiException.class)
    public void removePage_Faulty() {
        this.createSite(new SiteId("test1"), "page1");
        this.runWithFault(new Runnable(){

            @Override
            public void run() {
                PortalImplTest.this.portal.removePage(new PageId("removePage", "page1"));
            }
        });
    }

    @Test
    public void removePage_NonExisting() {
        this.createSite(new SiteId("test1"), "page1");
        Assert.assertFalse((boolean)this.portal.removePage(new PageId("test1", "page2")));
    }

    @Test(expected=EntityNotFoundException.class)
    public void removePage_SiteNonExisting() {
        this.createSite(new SiteId("test1"), "page1");
        Assert.assertFalse((boolean)this.portal.removePage(new PageId("test2", "page1")));
    }

    @Test(expected=IllegalArgumentException.class)
    public void removePage_NullSiteId() {
        this.portal.removePage(null);
    }

    @Test
    public void removeSite() {
        this.createSite(new SiteId("test1"), new String[0]);
        this.createSite(new SiteId("test2"), new String[0]);
        this.createSite(new SiteId("test3"), new String[0]);
        Assert.assertNotNull((Object)this.portal.getSite(new SiteId("test1")));
        Assert.assertNotNull((Object)this.portal.getSite(new SiteId("test2")));
        Assert.assertNotNull((Object)this.portal.getSite(new SiteId("test3")));
        Assert.assertTrue((boolean)this.portal.removeSite(new SiteId("test1")));
        Assert.assertNull((Object)this.portal.getSite(new SiteId("test1")));
        Assert.assertNotNull((Object)this.portal.getSite(new SiteId("test2")));
        Assert.assertNotNull((Object)this.portal.getSite(new SiteId("test3")));
        Assert.assertTrue((boolean)this.portal.removeSite(new SiteId(SiteType.SITE, "test2")));
        Assert.assertNull((Object)this.portal.getSite(new SiteId("te")));
        Assert.assertNull((Object)this.portal.getSite(new SiteId("test2")));
        Assert.assertNotNull((Object)this.portal.getSite(new SiteId("test3")));
    }

    @Test(expected=ApiException.class)
    public void removeSite_Faulty() {
        this.createSite(new SiteId("test1"), new String[0]);
        this.runWithFault(new Runnable(){

            @Override
            public void run() {
                PortalImplTest.this.portal.removeSite(new SiteId("test1"));
            }
        });
    }

    @Test
    public void removeSite_NonExisting() {
        Assert.assertFalse((boolean)this.portal.removeSite(new SiteId("test1")));
    }

    @Test(expected=IllegalArgumentException.class)
    public void removeSite_NullSiteId() {
        this.portal.removeSite(null);
    }

    @Test
    public void savePage() {
        this.createSite(new SiteId("create-page"), new String[0]);
        Permission access = new Permission("*", new Group("access"));
        Permission edit = new Permission("*", new Group("edit"));
        Page page = this.portal.createPage(new PageId("create-page", "baz"));
        page.setAccessPermission(access);
        page.setDescription("description");
        page.setDisplayName("displayName");
        page.setEditPermission(edit);
        this.portal.savePage(page);
        page = this.portal.getPage(new PageId("create-page", "baz"));
        Assert.assertNotNull((Object)page);
        Assert.assertEquals(access, page.getAccessPermission());
        Assert.assertEquals((Object)"description", (Object)page.getDescription());
        Assert.assertEquals((Object)"displayName", (Object)page.getDisplayName());
        Assert.assertEquals(edit, page.getEditPermission());
        Assert.assertEquals((Object)new PageId("create-page", "baz"), (Object)page.getId());
        Assert.assertEquals((Object)"baz", (Object)page.getName());
        Assert.assertEquals((Object)new SiteId("create-page"), (Object)page.getSiteId());
    }

    @Test(expected=EntityNotFoundException.class)
    public void savePage_NoSite() {
        Site site = this.portal.createSite(new SiteId("save-page"), "basic");
        this.portal.saveSite(site);
        Page page = this.portal.createPage(new PageId("no-site", "baz"));
        this.portal.removeSite(site.getId());
        this.portal.savePage(page);
    }

    @Test(expected=EntityAlreadyExistsException.class)
    public void savePage_Exists() {
        this.createSite(new SiteId("create-page"), new String[0]);
        Page pageA = this.portal.createPage(new PageId("create-page", "baz"));
        Page pageB = this.portal.createPage(new PageId("create-page", "baz"));
        this.portal.savePage(pageA);
        this.portal.savePage(pageB);
    }

    @Test(expected=ApiException.class)
    public void savePage_Faulty() {
        this.createSite(new SiteId("create-page"), new String[0]);
        final Page page = this.portal.createPage(new PageId("create-page", "baz"));
        this.runWithFault(new Runnable(){

            @Override
            public void run() {
                PortalImplTest.this.portal.savePage(page);
            }
        });
    }

    @Test
    public void savePage_Modify() {
        this.savePage();
        Permission access = new Permission("*", new Group("newAccess"));
        Permission edit = new Permission("*", new Group("newEdit"));
        Page page = this.portal.getPage(new PageId("create-page", "baz"));
        page.setAccessPermission(access);
        page.setDescription("newDescription");
        page.setDisplayName("newDisplayName");
        page.setEditPermission(edit);
        this.portal.savePage(page);
        page = this.portal.getPage(new PageId("create-page", "baz"));
        Assert.assertNotNull((Object)page);
        Assert.assertEquals(access, page.getAccessPermission());
        Assert.assertEquals((Object)"newDescription", (Object)page.getDescription());
        Assert.assertEquals((Object)"newDisplayName", (Object)page.getDisplayName());
        Assert.assertEquals(edit, page.getEditPermission());
        Assert.assertEquals((Object)new PageId("create-page", "baz"), (Object)page.getId());
        Assert.assertEquals((Object)"baz", (Object)page.getName());
        Assert.assertEquals((Object)new SiteId("create-page"), (Object)page.getSiteId());
    }

    @Test(expected=IllegalArgumentException.class)
    public void savePage_Null() {
        this.portal.savePage(null);
    }

    @Test
    public void saveSite() {
        Permission access = new Permission("*", new Group("access"));
        Permission edit = new Permission("*", new Group("edit"));
        Site site = this.portal.createSite(new SiteId("newsite"), "basic");
        site.setAccessPermission(access);
        site.setDisplayName("displayName");
        site.setDescription("description");
        site.setEditPermission(edit);
        site.setLocale(Locale.ENGLISH);
        site.setSkin("skin");
        site.getAttributes().put(Attributes.key((String)"attributeKey", String.class), (Object)"attributeValue");
        this.portal.saveSite(site);
        site = this.portal.getSite(new SiteId("newsite"));
        Assert.assertNotNull((Object)site);
        Assert.assertEquals((Object)"displayName", (Object)site.getDisplayName());
        Assert.assertEquals((Object)"description", (Object)site.getDescription());
        Assert.assertEquals(access, site.getAccessPermission());
        Assert.assertEquals(edit, site.getEditPermission());
        Assert.assertEquals((Object)new SiteId("newsite"), (Object)site.getId());
        Assert.assertEquals((Object)Locale.ENGLISH, (Object)site.getLocale());
        Assert.assertEquals((Object)"newsite", (Object)site.getName());
        Assert.assertEquals((Object)"skin", (Object)site.getSkin());
        Assert.assertEquals((Object)SiteType.SITE, (Object)site.getType());
        Assert.assertEquals((long)1L, (long)site.getAttributes().size());
        Assert.assertEquals((Object)"attributeValue", (Object)site.getAttributes().get(Attributes.key((String)"attributeKey", String.class)));
        Assert.assertNull((Object)this.portal.getSite(new SiteId("xxx")));
    }

    @Test(expected=ApiException.class)
    public void saveSite_Exists() {
        Site siteA = this.portal.createSite(new SiteId("newsite"), "basic");
        Site siteB = this.portal.createSite(new SiteId("newsite"), "basic");
        this.portal.saveSite(siteA);
        this.portal.saveSite(siteB);
    }

    @Test(expected=ApiException.class)
    public void saveSite_Faulty() {
        final Site site = this.portal.createSite(new SiteId("newsite"), "basic");
        this.runWithFault(new Runnable(){

            @Override
            public void run() {
                PortalImplTest.this.portal.saveSite(site);
            }
        });
    }

    @Test
    public void saveSite_Modify() {
        this.saveSite();
        Permission access = new Permission("*", new Group("newAccess"));
        Permission edit = new Permission("*", new Group("newEdit"));
        Site site = this.portal.getSite(new SiteId("newsite"));
        site.setAccessPermission(access);
        site.setDisplayName("newDisplayName");
        site.setDescription("newDescription");
        site.setEditPermission(edit);
        site.setLocale(Locale.SIMPLIFIED_CHINESE);
        site.setSkin("newSkin");
        site.getAttributes().put(Attributes.key((String)"attributeKey", String.class), (Object)"newAttributeValue");
        site.getAttributes().put(Attributes.key((String)"attributeKey2", String.class), (Object)"attributeValue2");
        this.portal.saveSite(site);
        site = this.portal.getSite(new SiteId("newsite"));
        Assert.assertNotNull((Object)site);
        Assert.assertEquals((Object)"newDisplayName", (Object)site.getDisplayName());
        Assert.assertEquals((Object)"newDescription", (Object)site.getDescription());
        Assert.assertEquals(access, site.getAccessPermission());
        Assert.assertEquals(edit, site.getEditPermission());
        Assert.assertEquals((Object)new SiteId("newsite"), (Object)site.getId());
        Assert.assertEquals((Object)Locale.SIMPLIFIED_CHINESE, (Object)site.getLocale());
        Assert.assertEquals((Object)"newsite", (Object)site.getName());
        Assert.assertEquals((Object)"newSkin", (Object)site.getSkin());
        Assert.assertEquals((Object)SiteType.SITE, (Object)site.getType());
        Assert.assertEquals((long)2L, (long)site.getAttributes().size());
        Assert.assertEquals((Object)"newAttributeValue", (Object)site.getAttributes().get(Attributes.key((String)"attributeKey", String.class)));
        Assert.assertEquals((Object)"attributeValue2", (Object)site.getAttributes().get(Attributes.key((String)"attributeKey2", String.class)));
    }

    @Test(expected=IllegalArgumentException.class)
    public void saveSite_Null() {
        this.portal.saveSite(null);
    }

    @Test
    public void serializePage() throws Exception {
        this.createSite(new SiteId("classic"), new String[0]);
        Permission access = Permission.any((String[])new String[]{"/platform/administrators"});
        Permission edit = Permission.everyone();
        Page page = this.portal.createPage(new PageId("classic", "page1"));
        page.setAccessPermission(access);
        page.setDescription("description");
        page.setDisplayName("displayName");
        page.setEditPermission(edit);
        Page serialized = SerializationUtils.serializeDeserialize(page);
        Assert.assertNotNull((Object)serialized);
        Assert.assertEquals(access, serialized.getAccessPermission());
        Assert.assertEquals((Object)"description", (Object)serialized.getDescription());
        Assert.assertEquals((Object)"displayName", (Object)serialized.getDisplayName());
        Assert.assertEquals(edit, serialized.getEditPermission());
        Assert.assertEquals((Object)new PageId("classic", "page1"), (Object)serialized.getId());
        Assert.assertEquals((Object)"page1", (Object)serialized.getName());
        Assert.assertEquals((Object)new SiteId("classic"), (Object)serialized.getSiteId());
        this.portal.savePage(page);
        Page saved = this.portal.getPage(page.getId());
        Page savedSerialized = SerializationUtils.serializeDeserialize(saved);
        Assert.assertNotNull((Object)savedSerialized);
        Assert.assertEquals(access, savedSerialized.getAccessPermission());
        Assert.assertEquals((Object)"description", (Object)savedSerialized.getDescription());
        Assert.assertEquals((Object)"displayName", (Object)savedSerialized.getDisplayName());
        Assert.assertEquals(edit, savedSerialized.getEditPermission());
        Assert.assertEquals((Object)new PageId("classic", "page1"), (Object)savedSerialized.getId());
        Assert.assertEquals((Object)"page1", (Object)savedSerialized.getName());
        Assert.assertEquals((Object)new SiteId("classic"), (Object)savedSerialized.getSiteId());
    }

    @Test
    public void serializeSite() throws Exception {
        Permission access = new Permission("*", new Group("access"));
        Permission edit = new Permission("*", new Group("edit"));
        Site site = this.portal.createSite(new SiteId("newsite"), "basic");
        site.setAccessPermission(access);
        site.setDisplayName("displayName");
        site.setDescription("description");
        site.setEditPermission(edit);
        site.setLocale(Locale.ENGLISH);
        site.setSkin("skin");
        site.getAttributes().put(Attributes.key((String)"attributeKey", String.class), (Object)"attributeValue");
        site = SerializationUtils.serializeDeserialize(site);
        Assert.assertNotNull((Object)site);
        Assert.assertEquals((Object)"displayName", (Object)site.getDisplayName());
        Assert.assertEquals((Object)"description", (Object)site.getDescription());
        Assert.assertEquals(access, site.getAccessPermission());
        Assert.assertEquals(edit, site.getEditPermission());
        Assert.assertEquals((Object)new SiteId("newsite"), (Object)site.getId());
        Assert.assertEquals((Object)Locale.ENGLISH, (Object)site.getLocale());
        Assert.assertEquals((Object)"newsite", (Object)site.getName());
        Assert.assertEquals((Object)"skin", (Object)site.getSkin());
        Assert.assertEquals((Object)SiteType.SITE, (Object)site.getType());
        Assert.assertEquals((long)1L, (long)site.getAttributes().size());
        Assert.assertEquals((Object)"attributeValue", (Object)site.getAttributes().get(Attributes.key((String)"attributeKey", String.class)));
        this.portal.saveSite(site);
        site = this.portal.getSite(new SiteId("newsite"));
        site = SerializationUtils.serializeDeserialize(site);
        Assert.assertNotNull((Object)site);
        Assert.assertEquals((Object)"displayName", (Object)site.getDisplayName());
        Assert.assertEquals((Object)"description", (Object)site.getDescription());
        Assert.assertEquals(access, site.getAccessPermission());
        Assert.assertEquals(edit, site.getEditPermission());
        Assert.assertEquals((Object)new SiteId("newsite"), (Object)site.getId());
        Assert.assertEquals((Object)Locale.ENGLISH, (Object)site.getLocale());
        Assert.assertEquals((Object)"newsite", (Object)site.getName());
        Assert.assertEquals((Object)"skin", (Object)site.getSkin());
        Assert.assertEquals((Object)SiteType.SITE, (Object)site.getType());
        Assert.assertEquals((long)1L, (long)site.getAttributes().size());
        Assert.assertEquals((Object)"attributeValue", (Object)site.getAttributes().get(Attributes.key((String)"attributeKey", String.class)));
    }

    private void runWithFault(Runnable r) {
        RequestLifeCycle.end();
        try {
            r.run();
        }
        finally {
            RequestLifeCycle.begin((ExoContainer)this.container);
        }
    }
}

