/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.api;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.LocaleUtils;
import org.exoplatform.portal.config.model.Properties;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.page.PageKey;
import org.gatein.api.common.Attributes;
import org.gatein.api.page.PageId;
import org.gatein.api.security.Group;
import org.gatein.api.security.Membership;
import org.gatein.api.security.Permission;
import org.gatein.api.security.User;
import org.gatein.api.site.Site;
import org.gatein.api.site.SiteId;
import org.gatein.api.site.SiteType;

public class Util {
    public static Properties from(Attributes attributes) {
        if (attributes == null) {
            return null;
        }
        Properties properties = new Properties();
        properties.putAll((Map)attributes);
        for (String key : properties.keySet()) {
            if (!key.equals(Site.AttributeKeys.SHOW_PORTLET_INFO_BAR.getName())) continue;
            String value = (String)properties.get((Object)key);
            boolean show = Boolean.parseBoolean(value);
            if (show) {
                properties.put((Object)key, (Object)"1");
                continue;
            }
            properties.put((Object)key, (Object)"0");
        }
        return properties;
    }

    public static Attributes from(Properties properties) {
        if (properties == null) {
            return new Attributes();
        }
        Attributes attributes = new Attributes();
        for (Map.Entry e : properties.entrySet()) {
            String key = (String)e.getKey();
            String value = (String)e.getValue();
            if (key.equals(Site.AttributeKeys.SHOW_PORTLET_INFO_BAR.getName())) {
                if ("0".equals(value)) {
                    attributes.put(Site.AttributeKeys.SHOW_PORTLET_INFO_BAR, (Object)Boolean.FALSE);
                    continue;
                }
                if ("1".equals(value)) {
                    attributes.put(Site.AttributeKeys.SHOW_PORTLET_INFO_BAR, (Object)Boolean.TRUE);
                    continue;
                }
                attributes.put((Object)key, (Object)value);
                continue;
            }
            attributes.put((Object)key, (Object)value);
        }
        return attributes;
    }

    public static PageId from(PageKey pageKey) {
        if (pageKey == null) {
            return null;
        }
        SiteKey siteKey = pageKey.getSite();
        switch (pageKey.getSite().getType()) {
            case PORTAL: {
                return new PageId(siteKey.getName(), pageKey.getName());
            }
            case GROUP: {
                return new PageId(new Group(siteKey.getName()), pageKey.getName());
            }
            case USER: {
                return new PageId(new User(siteKey.getName()), pageKey.getName());
            }
        }
        throw new AssertionError();
    }

    public static PageKey from(PageId pageId) {
        if (pageId == null) {
            return null;
        }
        return new PageKey(Util.from(pageId.getSiteId()), pageId.getPageName());
    }

    public static SiteId from(SiteKey siteKey) {
        if (siteKey == null) {
            return null;
        }
        switch (siteKey.getType()) {
            case PORTAL: {
                return new SiteId(siteKey.getName());
            }
            case GROUP: {
                return new SiteId(new Group(siteKey.getName()));
            }
            case USER: {
                return new SiteId(new User(siteKey.getName()));
            }
        }
        throw new AssertionError();
    }

    public static SiteKey from(SiteId siteId) {
        if (siteId == null) {
            return null;
        }
        switch (siteId.getType()) {
            case SITE: {
                return SiteKey.portal((String)siteId.getName());
            }
            case SPACE: {
                return SiteKey.group((String)siteId.getName());
            }
            case DASHBOARD: {
                return SiteKey.user((String)siteId.getName());
            }
        }
        throw new AssertionError();
    }

    public static org.exoplatform.portal.mop.SiteType from(SiteType siteType) {
        if (siteType == null) {
            return null;
        }
        switch (siteType) {
            case SITE: {
                return org.exoplatform.portal.mop.SiteType.PORTAL;
            }
            case SPACE: {
                return org.exoplatform.portal.mop.SiteType.GROUP;
            }
            case DASHBOARD: {
                return org.exoplatform.portal.mop.SiteType.USER;
            }
        }
        throw new AssertionError();
    }

    public static Permission from(String ... permissions) {
        if (permissions == null) {
            return null;
        }
        if (permissions.length == 1 && permissions[0] == null) {
            return null;
        }
        return Util.from(Arrays.asList(permissions));
    }

    public static Permission from(List<String> permissions) {
        if (permissions == null) {
            return null;
        }
        if (permissions.size() == 1 && permissions.get(0).equals("Everyone")) {
            return Permission.everyone();
        }
        LinkedHashSet<Membership> memberships = new LinkedHashSet<Membership>(permissions.size());
        for (String permission : permissions) {
            memberships.add(Membership.fromString((String)permission));
        }
        return new Permission(memberships);
    }

    public static String[] from(Permission permission) {
        if (permission == null) {
            return null;
        }
        if (permission.isAccessibleToEveryone()) {
            return new String[]{"Everyone"};
        }
        String[] permissions = new String[permission.getMemberships().size()];
        Iterator memberships = permission.getMemberships().iterator();
        for (int i = 0; i < permissions.length; ++i) {
            permissions[i] = ((Membership)memberships.next()).toString();
        }
        return permissions;
    }

    public static Locale toLocale(String locale) {
        return LocaleUtils.toLocale((String)locale);
    }

    public static String fromLocale(Locale locale) {
        return locale.toString();
    }
}

