/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.application.registry.impl;

import java.util.Date;
import java.util.List;
import org.chromattic.api.annotations.FormattedBy;
import org.chromattic.api.annotations.Id;
import org.chromattic.api.annotations.ManyToOne;
import org.chromattic.api.annotations.Name;
import org.chromattic.api.annotations.NamingPrefix;
import org.chromattic.api.annotations.PrimaryType;
import org.chromattic.api.annotations.Property;
import org.chromattic.ext.format.BaseEncodingObjectFormatter;
import org.exoplatform.application.registry.impl.CategoryDefinition;
import org.exoplatform.portal.pom.config.POMSession;
import org.gatein.mop.api.content.Customization;
import org.gatein.mop.api.workspace.Workspace;

@PrimaryType(name="app:application")
@FormattedBy(value=BaseEncodingObjectFormatter.class)
@NamingPrefix(value="app")
public abstract class ContentDefinition {
    @Id
    public abstract String getId();

    @Name
    public abstract String getName();

    @Property(name="gtn:name")
    public abstract String getDisplayName();

    public abstract void setDisplayName(String var1);

    @Property(name="gtn:description")
    public abstract String getDescription();

    public abstract void setDescription(String var1);

    @Property(name="app:creationdate")
    public abstract Date getCreationDate();

    public abstract void setCreationDate(Date var1);

    @Property(name="app:lastmodificationdate")
    public abstract Date getLastModificationDate();

    public abstract void setLastModificationDate(Date var1);

    @Property(name="gtn:access-permissions")
    public abstract List<String> getAccessPermissions();

    public abstract void setAccessPermissions(List<String> var1);

    @ManyToOne
    public abstract CategoryDefinition getCategory();

    public Customization getCustomization() {
        CategoryDefinition category = this.getCategory();
        POMSession session = category.registry.mopManager.getSession();
        Workspace workspace = session.getWorkspace();
        String name = this.getName();
        return workspace.getCustomizationContext().getCustomization(name);
    }
}

