/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.xml;

import java.io.IOException;
import java.io.Writer;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.exoplatform.commons.utils.HTMLEntityEncoder;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMSerializer {
    private static final Logger log;
    private static final XMLOutputFactory outputFactory;
    private static final String DEFAULT_XML_OUTPUT_FACTORY = "com.sun.xml.internal.stream.XMLOutputFactoryImpl";

    public static void serialize(Element element, Writer writer) throws IOException, XMLStreamException {
        XMLStreamWriter xml = outputFactory.createXMLStreamWriter(writer);
        DOMSerializer.serialize(element, xml);
        xml.writeEndDocument();
        xml.flush();
    }

    private static void serialize(Element element, XMLStreamWriter writer) throws IOException, XMLStreamException {
        Node child;
        int i;
        int length;
        NodeList children;
        boolean empty;
        String tagName = element.getTagName();
        if (tagName.equalsIgnoreCase("script")) {
            empty = false;
        } else {
            empty = true;
            children = element.getChildNodes();
            length = children.getLength();
            for (i = 0; i < length && empty; ++i) {
                child = children.item(i);
                if (child instanceof CharacterData) {
                    empty = false;
                    continue;
                }
                if (!(child instanceof Element)) continue;
                empty = false;
            }
        }
        if (empty) {
            writer.writeEmptyElement(tagName);
        } else {
            writer.writeStartElement(tagName);
        }
        if (element.hasAttributes()) {
            NamedNodeMap attrs = element.getAttributes();
            length = attrs.getLength();
            for (i = 0; i < length; ++i) {
                Attr attr = (Attr)attrs.item(i);
                writer.writeAttribute(attr.getName(), attr.getValue());
            }
        }
        if (!empty) {
            children = element.getChildNodes();
            length = children.getLength();
            for (i = 0; i < length; ++i) {
                child = children.item(i);
                if (child instanceof CDATASection) {
                    writer.writeCData(((CDATASection)child).getData());
                    continue;
                }
                if (child instanceof CharacterData) {
                    DOMSerializer.writeTextData(writer, ((CharacterData)child).getData());
                    continue;
                }
                if (!(child instanceof Element)) continue;
                DOMSerializer.serialize((Element)child, writer);
            }
            writer.writeEndElement();
        }
    }

    private static void writeTextData(XMLStreamWriter writer, String data) throws XMLStreamException {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < data.length(); ++i) {
            char c = data.charAt(i);
            String encodedValue = HTMLEntityEncoder.getInstance().lookupEntityName(c);
            if (encodedValue == null) {
                builder.append(c);
                continue;
            }
            builder.append(encodedValue);
        }
        writer.writeCharacters(builder.toString());
    }

    static {
        XMLOutputFactory tmp;
        log = LoggerFactory.getLogger(DOMSerializer.class);
        try {
            Class<?> cl = Thread.currentThread().getContextClassLoader().loadClass(DEFAULT_XML_OUTPUT_FACTORY);
            tmp = (XMLOutputFactory)cl.newInstance();
        }
        catch (Exception e) {
            tmp = XMLOutputFactory.newInstance();
            log.warn((Object)("Could not instantiate com.sun.xml.internal.stream.XMLOutputFactoryImpl will use default provided by runtime instead " + tmp.getClass().getName()));
        }
        outputFactory = tmp;
    }
}

