/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.serialization.serial;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.IdentityHashMap;
import org.exoplatform.commons.serialization.SerializationContext;
import org.exoplatform.commons.serialization.api.TypeConverter;
import org.exoplatform.commons.serialization.model.ClassTypeModel;
import org.exoplatform.commons.serialization.model.ConvertedTypeModel;
import org.exoplatform.commons.serialization.model.FieldModel;
import org.exoplatform.commons.serialization.model.SerializationMode;
import org.exoplatform.commons.serialization.model.TypeModel;
import org.exoplatform.commons.serialization.serial.DataContainer;
import org.exoplatform.commons.serialization.serial.SerializationStatus;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

public class ObjectWriter
extends ObjectOutputStream {
    private static final Logger log = LoggerFactory.getLogger(ObjectWriter.class);
    private final SerializationContext context;
    private final IdentityHashMap<Object, Integer> objectToId;

    public ObjectWriter(SerializationContext context, OutputStream out) throws IOException {
        super(out);
        this.enableReplaceObject(true);
        this.context = context;
        this.objectToId = new IdentityHashMap();
    }

    private int register(Object o) {
        int nextId = this.objectToId.size();
        this.objectToId.put(o, nextId);
        return nextId;
    }

    private void write(Object obj, DataContainer output) throws IOException {
        Class<?> objClass = obj.getClass();
        TypeModel<?> typeModel = this.context.getTypeDomain().getTypeModel(objClass);
        if (typeModel == null) {
            throw new NotSerializableException("Object " + obj + " does not have its type described");
        }
        if (typeModel instanceof ClassTypeModel) {
            this.write((ClassTypeModel)typeModel, obj, output);
        } else {
            this.write((ConvertedTypeModel)typeModel, obj, output);
        }
    }

    private <O, T> void write(ConvertedTypeModel<O, T> typeModel, O obj, DataContainer output) throws IOException {
        T target;
        TypeConverter<O, T> converter;
        Class<TypeConverter<O, T>> converterClass = typeModel.getConverterJavaType();
        try {
            converter = converterClass.newInstance();
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
        try {
            target = converter.write(obj);
        }
        catch (Exception e) {
            InvalidObjectException ioe = new InvalidObjectException("The object " + obj + " conversion threw an exception ");
            ioe.initCause(e);
            throw ioe;
        }
        if (target == null) {
            throw new InvalidObjectException("The object " + obj + " was converted to null by converter " + converter);
        }
        output.writeInt(3);
        output.writeObject(typeModel.getJavaType());
        this.write(target, output);
    }

    private <O> void write(ClassTypeModel<O> typeModel, O obj, DataContainer output) throws IOException {
        if (typeModel.getSerializationMode() == SerializationMode.SERIALIZED) {
            output.writeInt(0);
            output.writeInt(this.register(obj));
            output.writeObject(typeModel.getJavaType());
            SerializationStatus status = SerializationStatus.NONE;
            for (TypeModel currentTypeModel = typeModel; currentTypeModel != null; currentTypeModel = currentTypeModel.getSuperType()) {
                if (currentTypeModel instanceof ClassTypeModel) {
                    for (FieldModel<O, ?> fieldModel : currentTypeModel.getFields()) {
                        if (fieldModel.isTransient()) continue;
                        Object fieldValue = fieldModel.get(obj);
                        if (fieldValue == null) {
                            output.writeObject(1);
                            continue;
                        }
                        Integer fieldValueId = this.objectToId.get(fieldValue);
                        if (fieldValueId != null) {
                            output.writeObject(2);
                            output.writeInt(fieldValueId);
                            continue;
                        }
                        output.writeObject(0);
                        output.writeObject(fieldValue);
                    }
                    switch (status) {
                        case NONE: {
                            status = SerializationStatus.FULL;
                        }
                    }
                    continue;
                }
                if (currentTypeModel.getFields().isEmpty()) continue;
                switch (status) {
                    case FULL: {
                        status = SerializationStatus.PARTIAL;
                    }
                }
            }
            switch (status) {
                case FULL: {
                    break;
                }
                case PARTIAL: {
                    log.debug((Object)("Partial serialization of object " + obj));
                    break;
                }
                case NONE: {
                    throw new NotSerializableException("Type " + typeModel + " is not serializable");
                }
            }
        } else if (typeModel.getSerializationMode() == SerializationMode.SERIALIZABLE) {
            output.writeInt(4);
            output.writeObject(obj);
        } else {
            throw new NotSerializableException("Type " + typeModel + " is not serializable");
        }
    }

    @Override
    protected Object replaceObject(Object obj) throws IOException {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Serializable) {
            return obj;
        }
        DataContainer output = new DataContainer();
        Integer id = this.objectToId.get(obj);
        if (id != null) {
            output = new DataContainer();
            output.writeInt(2);
            output.writeObject(id);
        } else {
            this.write(obj, output);
        }
        return output;
    }
}

