/*
 * Copyright (C) 2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.exoplatform.commons.serialization.api.factory;

import java.util.Map;

import org.exoplatform.commons.serialization.model.FieldModel;

/**
 * A factory that creates instance of a type.
 *
 * @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a>
 * @version $Revision$
 * @param <B> the paraemter type of the base type
 */
public abstract class ObjectFactory<B> {

    /**
     * Instantiate an object based on the provided type. The implementor should take care of configuring the state of the
     * returned objet with the provided state map argument.
     *
     * @param type the type
     * @param state the state
     * @param <S> the parameter type of the sub type of the base type
     * @return the S instance
     * @throws CreateException anything wrong that happened during instance creation
     */
    public abstract <S extends B> S create(Class<S> type, Map<FieldModel<? super S, ?>, ?> state) throws CreateException;

}
