/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.common.xml.stax.writer;

import java.io.OutputStream;
import java.io.Writer;
import javax.xml.namespace.QName;
import org.gatein.common.xml.stax.writer.StaxWriter;
import org.gatein.common.xml.stax.writer.WritableValueType;
import org.gatein.common.xml.stax.writer.builder.StaxFormatterBuilder;
import org.gatein.common.xml.stax.writer.builder.StaxFormatterBuilderImpl;
import org.gatein.common.xml.stax.writer.builder.StaxWriterBuilder;
import org.gatein.common.xml.stax.writer.builder.StaxWriterBuilderImpl;
import org.gatein.common.xml.stax.writer.formatting.XmlStreamingFormatter;
import org.staxnav.EnumElement;
import org.staxnav.Naming;
import org.staxnav.StaxNavException;

public class StaxWriterUtils {
    private static final int DEFAULT_INDENT_SIZE = 3;
    private static final char DEFAULT_INDENT_CHAR = ' ';
    private static final String DEFAULT_NEWLINE;

    public static <N> StaxWriter<N> createWriter(Naming<N> naming, OutputStream outputStream) throws StaxNavException {
        return StaxWriterUtils.buildDefaultWriter(outputStream).build(naming);
    }

    public static StaxWriter<String> createWriter(OutputStream outputStream) throws StaxNavException {
        return StaxWriterUtils.createWriter(new Naming.Local(), outputStream);
    }

    public static StaxWriter<QName> createQualifiedWriter(OutputStream outputStream) throws StaxNavException {
        return StaxWriterUtils.createWriter(new Naming.Qualified(), outputStream);
    }

    public static <E extends Enum<E>> StaxWriter<E> createWriter(Class<E> enumeratedClass, OutputStream outputStream) throws StaxNavException {
        Object naming = EnumElement.class.isAssignableFrom(enumeratedClass) ? new Naming.Enumerated.Mapped(enumeratedClass, null) : new Naming.Enumerated.Simple(enumeratedClass, null);
        return StaxWriterUtils.createWriter(naming, outputStream);
    }

    public static <N> StaxWriter<N> createWriter(Naming<N> naming, Writer writer) throws StaxNavException {
        return StaxWriterUtils.buildDefaultWriter().withWriter(writer).build(naming);
    }

    public static StaxWriter<String> createWriter(Writer writer) throws StaxNavException {
        return StaxWriterUtils.createWriter(new Naming.Local(), writer);
    }

    public static StaxWriter<QName> createQualifiedWriter(Writer writer) throws StaxNavException {
        return StaxWriterUtils.createWriter(new Naming.Qualified(), writer);
    }

    public static <E extends Enum<E>> StaxWriter<E> createWriter(Class<E> enumeratedClass, Writer writer) throws StaxNavException {
        Object naming = EnumElement.class.isAssignableFrom(enumeratedClass) ? new Naming.Enumerated.Mapped(enumeratedClass, null) : new Naming.Enumerated.Simple(enumeratedClass, null);
        return StaxWriterUtils.createWriter(naming, writer);
    }

    public static StaxWriterBuilder buildWriter() {
        return new StaxWriterBuilderImpl();
    }

    public static XmlStreamingFormatter createFormatter() {
        return StaxWriterUtils.buildFormatter().withNewline(DEFAULT_NEWLINE).ofIndentSize(3).withIndentCharacter(' ').build();
    }

    public static XmlStreamingFormatter createFormatter(int indentSize) {
        return StaxWriterUtils.buildFormatter().withNewline(DEFAULT_NEWLINE).ofIndentSize(indentSize).withIndentCharacter(' ').build();
    }

    public static StaxFormatterBuilder buildFormatter() {
        return new StaxFormatterBuilderImpl();
    }

    public static <N> void writeOptionalElement(StaxWriter<N> writer, N element, String content) {
        if (content == null) {
            return;
        }
        writer.writeElement(element, content);
    }

    public static <N, V> void writeOptionalElement(StaxWriter<N> writer, N element, WritableValueType<V> valueType, V value) {
        if (value == null) {
            return;
        }
        writer.writeElement(element, valueType, value);
    }

    public static <N> void writeOptionalContent(StaxWriter<N> writer, N element, String content) {
        writer.writeStartElement(element);
        if (content != null) {
            writer.writeContent(content);
        }
        writer.writeEndElement();
    }

    public static <N, V> void writeOptionalContent(StaxWriter<N> writer, N element, WritableValueType<V> valueType, V value) {
        writer.writeStartElement(element);
        if (value != null) {
            writer.writeContent(valueType, value);
        }
        writer.writeEndElement();
    }

    private static StaxWriterBuilder buildDefaultWriter() {
        return StaxWriterUtils.buildWriter().withEncoding("UTF-8").withVersion("1.0").withPropertyIfSupported("com.ctc.wstx.outputEscapeCr", Boolean.FALSE).withFormatting(StaxWriterUtils.createFormatter());
    }

    private static StaxWriterBuilder buildDefaultWriter(OutputStream outputStream) {
        return StaxWriterUtils.buildWriter().withEncoding("UTF-8").withVersion("1.0").withPropertyIfSupported("com.ctc.wstx.outputEscapeCr", Boolean.FALSE).withFormatting(StaxWriterUtils.createFormatter()).withOutputStream(outputStream, "UTF-8");
    }

    private StaxWriterUtils() {
    }

    static {
        String newline = null;
        try {
            newline = System.getProperty("line.separator");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (newline == null) {
            newline = "\n";
        }
        DEFAULT_NEWLINE = newline;
    }
}

