/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.List;
import junit.framework.Assert;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.component.test.AbstractKernelTest;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.portal.component.test.jcr-configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.portal.component.identity-configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="org/exoplatform/services/organization/TestOrganization-configuration.xml")})
public class TestOrganization
extends AbstractKernelTest {
    private static final String GROUP_1 = "testOrganization_group1";
    private static final String GROUP_2 = "testOrganization_group2";
    private static final String GROUP_3 = "testOrganization_group3";
    private static final String USER_1 = "testOrganization_user1";
    private static final String USER_2 = "testOrganization_user2";
    private static final String USER_3 = "testOrganization_user3";
    private static final String DEFAULT_PASSWORD = "defaultpassword";
    private static final String DESCRIPTION = " Description";
    private OrganizationService organizationService;

    protected void setUp() throws Exception {
        super.setUp();
        this.begin();
        PortalContainer container = this.getContainer();
        this.organizationService = (OrganizationService)container.getComponentInstance(OrganizationService.class);
        this.createGroup(null, GROUP_1);
        this.createGroup(GROUP_1, GROUP_2);
        this.createGroup(GROUP_1, GROUP_3);
        this.createUser(USER_1, GROUP_1);
        this.createUser(USER_2, GROUP_2);
        this.createUser(USER_3, GROUP_1);
    }

    protected void tearDown() throws Exception {
        this.deleteGroup(GROUP_1);
        this.deleteGroup(GROUP_2);
        this.deleteGroup(GROUP_3);
        this.deleteUser(USER_1);
        this.deleteUser(USER_2);
        this.deleteUser(USER_3);
        this.end();
        super.tearDown();
    }

    public void testFindGroupNotFound() throws Exception {
        GroupHandler groupHander = this.organizationService.getGroupHandler();
        Group group = groupHander.findGroupById("testOrganization_group1NOTFOUND");
        TestOrganization.assertNull((Object)group);
    }

    public void testFindGroupFromRoot() throws Exception {
        GroupHandler handler = this.organizationService.getGroupHandler();
        Collection allGroups = handler.findGroups(null);
        Assert.assertTrue((allGroups.size() > 0 ? 1 : 0) != 0);
    }

    public void testFindGroupById() throws Exception {
        GroupHandler groupHandler = this.organizationService.getGroupHandler();
        Group group = groupHandler.findGroupById(GROUP_1);
        TestOrganization.assertNotNull((Object)group);
        TestOrganization.assertEquals((String)GROUP_1, (String)group.getGroupName());
        TestOrganization.assertEquals((String)"testOrganization_group1 Description", (String)group.getDescription());
        group = groupHandler.findGroupById(GROUP_3);
        TestOrganization.assertNotNull((Object)group);
        TestOrganization.assertEquals((String)GROUP_3, (String)group.getGroupName());
    }

    public void testFindGroupOfUser() {
        GroupHandler groupHandler = this.organizationService.getGroupHandler();
        try {
            Collection groups = groupHandler.findGroupsOfUser(USER_1);
            TestOrganization.assertNotNull((Object)groups);
            TestOrganization.assertTrue((groups.size() >= 1 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            TestOrganization.fail();
        }
    }

    public void testFindUserByGroup() throws Exception {
        GroupHandler groupHandler = this.organizationService.getGroupHandler();
        Group group = groupHandler.findGroupById(GROUP_1);
        UserHandler uHandler = this.organizationService.getUserHandler();
        PageList users = uHandler.findUsersByGroup("/platform/administrators");
        Assert.assertTrue((users.getAvailable() > 0 ? 1 : 0) != 0);
        List iterator = users.getAll();
        for (Object test : iterator) {
            User a = (User)test;
            System.out.println(a.getUserName());
        }
    }

    public void testChangePassword() throws Exception {
        UserHandler uHandler = this.organizationService.getUserHandler();
        User user = uHandler.findUserByName("root");
        Assert.assertNotNull((Object)user);
        Assert.assertTrue((boolean)uHandler.authenticate("root", "gtn"));
        user.setPassword("newPassword");
        uHandler.saveUser(user, false);
        user = uHandler.findUserByName("root");
        Assert.assertNotNull((Object)user);
        Assert.assertTrue((boolean)uHandler.authenticate("root", "newPassword"));
        user.setPassword("gtn");
        uHandler.saveUser(user, false);
    }

    public void testDisplayName() throws Exception {
        UserHandler uHandler = this.organizationService.getUserHandler();
        User john = uHandler.findUserByName("john");
        Assert.assertNotNull((Object)john);
        Assert.assertEquals((String)"John Anthony", (String)john.getFullName());
        john.setFullName("Johnny Something");
        uHandler.saveUser(john, false);
        john = uHandler.findUserByName("john");
        Assert.assertEquals((String)"Johnny Something", (String)john.getFullName());
        john.setFullName(null);
        uHandler.saveUser(john, false);
        john = uHandler.findUserByName("john");
        Assert.assertEquals((String)"John Anthony", (String)john.getFullName());
    }

    private void createGroup(String parent, String name) {
        GroupHandler groupHandler = this.organizationService.getGroupHandler();
        try {
            Group parentGroup = null;
            if (parent != null) {
                parentGroup = groupHandler.findGroupById(parent);
            }
            Group newGroup = groupHandler.createGroupInstance();
            newGroup.setGroupName(name);
            newGroup.setDescription(name + DESCRIPTION);
            newGroup.setLabel(name);
            if (parentGroup != null) {
                groupHandler.addChild(parentGroup, newGroup, true);
            }
            groupHandler.saveGroup(newGroup, true);
        }
        catch (Exception e) {
            TestOrganization.fail((String)("Error on create group [" + name + "] " + e.getMessage()), (Throwable)e);
        }
    }

    private void deleteGroup(String name) {
        GroupHandler groupHandler = this.organizationService.getGroupHandler();
        try {
            Group group = groupHandler.findGroupById(name);
            groupHandler.removeGroup(group, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void createUser(String username, String ... groups) {
        UserHandler userHandler = this.organizationService.getUserHandler();
        User user = userHandler.createUserInstance(username);
        user.setPassword(DEFAULT_PASSWORD);
        user.setFirstName("default");
        user.setLastName("default");
        user.setEmail("exo@exoportal.org");
        user.setOrganizationId(groups[0]);
        try {
            userHandler.createUser(user, true);
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter out = new PrintWriter(sw);
            e.printStackTrace(out);
            out.close();
            TestOrganization.fail((String)("Error on create user: " + sw.toString()));
        }
    }

    private void deleteUser(String username) {
        UserHandler userHandler = this.organizationService.getUserHandler();
        try {
            userHandler.removeUser(username, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

