/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.idm;

import javax.transaction.UserTransaction;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.organization.idm.PicketLinkIDMOrganizationServiceImpl;
import org.exoplatform.services.organization.idm.PicketLinkIDMService;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.common.transaction.JTAUserTransactionLifecycleService;
import org.picketlink.idm.api.IdentitySession;

public class AbstractDAOImpl {
    protected final PicketLinkIDMService service_;
    protected final PicketLinkIDMOrganizationServiceImpl orgService;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    public AbstractDAOImpl(PicketLinkIDMOrganizationServiceImpl orgService, PicketLinkIDMService idmService) {
        this.service_ = idmService;
        this.orgService = orgService;
    }

    public void handleException(String messageToLog, Exception e) {
        this.log.info((Object)messageToLog, (Throwable)e);
        if (this.orgService.getConfiguration().isUseJTA()) {
            try {
                JTAUserTransactionLifecycleService transactionLfService = (JTAUserTransactionLifecycleService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(JTAUserTransactionLifecycleService.class);
                UserTransaction tx = transactionLfService.getUserTransaction();
                if (tx.getStatus() == 0) {
                    tx.setRollbackOnly();
                }
            }
            catch (Exception tre) {
                this.log.warn((Object)"Unable to set Transaction status to be rollback only", (Throwable)tre);
            }
        } else {
            this.orgService.recoverFromIDMError(e);
        }
    }

    protected IdentitySession getIdentitySession() throws Exception {
        return this.service_.getIdentitySession();
    }
}

