/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.idm;

import java.security.PrivilegedAction;
import java.util.Map;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.database.impl.HibernateServiceImpl;
import org.gatein.common.classloader.DelegatingClassLoader;
import org.hibernate.SessionFactory;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.cfg.Configuration;
import org.hibernate.service.BootstrapServiceRegistry;
import org.hibernate.service.BootstrapServiceRegistryBuilder;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.ServiceRegistryBuilder;
import org.hibernate.service.internal.StandardServiceRegistryImpl;
import org.picketlink.idm.api.IdentitySessionFactory;

public class CustomHibernateServiceImpl
extends HibernateServiceImpl {
    private SessionFactory sessFactory;

    public CustomHibernateServiceImpl(InitParams initParams, CacheService cacheService) {
        super(initParams, cacheService);
    }

    public SessionFactory getSessionFactory() {
        if (this.sessFactory == null) {
            this.sessFactory = (SessionFactory)SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<SessionFactory>(){

                @Override
                public SessionFactory run() {
                    return CustomHibernateServiceImpl.this.buildSessionFactory();
                }
            });
        }
        return this.sessFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SessionFactory buildSessionFactory() {
        SessionFactory sessionFactory;
        block3: {
            Configuration conf = this.getHibernateConfiguration();
            BootstrapServiceRegistry bootstrapRegistry = this.createHibernateBootstrapServiceRegistry();
            final ServiceRegistry serviceRegistry = new ServiceRegistryBuilder(bootstrapRegistry).applySettings((Map)conf.getProperties()).buildServiceRegistry();
            conf.setSessionFactoryObserver(new SessionFactoryObserver(){

                public void sessionFactoryCreated(SessionFactory factory) {
                }

                public void sessionFactoryClosed(SessionFactory factory) {
                    ((StandardServiceRegistryImpl)serviceRegistry).destroy();
                }
            });
            final ClassLoader old = (ClassLoader)SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
            try {
                SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        DelegatingClassLoader cl = new DelegatingClassLoader(new ClassLoader[]{old, IdentitySessionFactory.class.getClassLoader()});
                        Thread.currentThread().setContextClassLoader((ClassLoader)cl);
                        return null;
                    }
                });
                sessionFactory = conf.buildSessionFactory(serviceRegistry);
                if (old == null) break block3;
            }
            catch (Throwable throwable) {
                if (old != null) {
                    SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Void>(old){
                        final /* synthetic */ ClassLoader val$old;
                        {
                            this.val$old = classLoader;
                        }

                        @Override
                        public Void run() {
                            Thread.currentThread().setContextClassLoader(this.val$old);
                            return null;
                        }
                    });
                }
                throw throwable;
            }
            SecurityHelper.doPrivilegedAction((PrivilegedAction)new /* invalid duplicate definition of identical inner class */);
        }
        return sessionFactory;
    }

    protected BootstrapServiceRegistry createHibernateBootstrapServiceRegistry() {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        ClassLoader hibernateCl = BootstrapServiceRegistry.class.getClassLoader();
        return new BootstrapServiceRegistryBuilder().withApplicationClassLoader(tccl).withHibernateClassLoader(hibernateCl).build();
    }
}

