/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.idm;

import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.UserStatus;
import org.exoplatform.services.organization.idm.IDMUserListAccess;
import org.gatein.common.NotYetImplemented;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.picketlink.idm.api.Group;
import org.picketlink.idm.common.exception.IdentityException;
import org.picketlink.idm.impl.cache.AbstractInfinispanCacheProvider;
import org.picketlink.idm.impl.tree.Fqn;
import org.picketlink.idm.impl.tree.Node;
import org.picketlink.idm.impl.tree.TreeCache;

public class IntegrationCache
extends AbstractInfinispanCacheProvider {
    private static final Logger log = LoggerFactory.getLogger(IntegrationCache.class);
    public static final String NODE_GTN_GROUP_ID = "NODE_GTN_GROUP_ID";
    public static final String NODE_PLIDM_ROOT_GROUP = "NODE_PLIDM_ROOT_GROUP";
    public static final String USER_QUERY_NODE = "GTN_USER_QUERY_LAZY_LIST";
    public static final String MAIN_ROOT = "NODE_GTN_ORG_SERVICE_INT_CACHE_MAIN_ROOT";
    public static final String NODE_OBJECT_KEY = "object";

    protected String getRootNode() {
        return MAIN_ROOT;
    }

    protected TreeCache getCacheFromRegistry(Object registry, String registryName) throws IdentityException {
        throw new NotYetImplemented("getCacheFromRegistry not implemented on IntegrationCache");
    }

    void putGtnGroupId(String ns, String pLIDMId, String id) {
        Fqn nodeFqn = this.getFqn(ns, NODE_GTN_GROUP_ID, pLIDMId);
        Node ioNode = this.addNode(nodeFqn);
        if (ioNode != null) {
            ioNode.put(NODE_OBJECT_KEY, (Object)id);
            if (log.isTraceEnabled()) {
                log.trace((Object)(((Object)((Object)this)).toString() + "GateIn group id cached. PLIDM group id: " + pLIDMId + "GateIn group id: " + id + ";namespace=" + ns));
            }
        }
    }

    String getGtnGroupId(String ns, String pLIDMId) {
        Fqn nodeFqn = this.getFqn(ns, NODE_GTN_GROUP_ID, pLIDMId);
        Node node = this.getNode(nodeFqn);
        if (node != null) {
            String id = (String)node.get(NODE_OBJECT_KEY);
            if (log.isTraceEnabled() && id != null) {
                log.trace((Object)(((Object)((Object)this)).toString() + "GateIn group id found in cache. PLIDM group id: " + pLIDMId + "GateIn group id: " + id + ";namespace=" + ns));
            }
            return id;
        }
        return null;
    }

    void putGtnUserLazyPageList(String ns, Query query, IDMUserListAccess list, UserStatus userStatus) {
        Fqn nodeFqn = this.getFqn(ns, USER_QUERY_NODE, this.getQueryKey(query, userStatus));
        Node ioNode = this.addNode(nodeFqn);
        if (ioNode != null) {
            ioNode.put(NODE_OBJECT_KEY, (Object)list);
            if (log.isTraceEnabled()) {
                log.trace((Object)(((Object)((Object)this)).toString() + "GateIn user query list cached. Query: " + this.getQueryKey(query, userStatus) + ";namespace=" + ns));
            }
        }
    }

    IDMUserListAccess getGtnUserLazyPageList(String ns, Query query, UserStatus userStatus) {
        Fqn nodeFqn = this.getFqn(ns, USER_QUERY_NODE, this.getQueryKey(query, userStatus));
        Node node = this.getNode(nodeFqn);
        if (node != null) {
            IDMUserListAccess list = (IDMUserListAccess)node.get(NODE_OBJECT_KEY);
            if (log.isTraceEnabled() && list != null) {
                log.trace((Object)(((Object)((Object)this)).toString() + "GateIn user query list found in cache. Query: " + this.getQueryKey(query, userStatus) + ";namespace=" + ns));
            }
            return list;
        }
        return null;
    }

    void putRootGroup(String ns, Group rootGroup) {
        Fqn nodeFqn = this.getFqn(ns, NODE_PLIDM_ROOT_GROUP);
        Node ioNode = this.addNode(nodeFqn);
        if (ioNode != null) {
            ioNode.put(NODE_OBJECT_KEY, (Object)rootGroup);
            if (log.isTraceEnabled()) {
                log.trace((Object)(((Object)((Object)this)).toString() + "GateIn root group stored in cache;namespace=" + ns));
            }
        }
    }

    Group getRootGroup(String ns) {
        Fqn nodeFqn = this.getFqn(ns, NODE_PLIDM_ROOT_GROUP);
        Node node = this.getNode(nodeFqn);
        if (node != null) {
            Group rootGroup = (Group)node.get(NODE_OBJECT_KEY);
            if (log.isTraceEnabled() && rootGroup != null) {
                log.trace((Object)(((Object)((Object)this)).toString() + "GateIn root group found in cache;namespace=" + ns));
            }
            return rootGroup;
        }
        return null;
    }

    String getQueryKey(Query query, UserStatus userStatus) {
        StringBuilder sb = new StringBuilder();
        String SEP = ":::";
        sb.append(query.getEmail()).append(SEP).append(query.getFirstName()).append(SEP).append(query.getLastName()).append(SEP).append(query.getUserName()).append(SEP).append(query.getFromLoginDate()).append(SEP).append(query.getToLoginDate()).append(SEP).append(userStatus.name()).append(SEP);
        return sb.toString();
    }
}

