/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.idm;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserStatus;
import org.exoplatform.services.organization.idm.PicketLinkIDMOrganizationServiceImpl;
import org.exoplatform.services.organization.idm.PicketLinkIDMService;
import org.exoplatform.services.organization.idm.Tools;
import org.exoplatform.services.organization.idm.UserDAOImpl;
import org.exoplatform.services.organization.impl.UserImpl;
import org.gatein.common.logging.LogLevel;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.picketlink.idm.api.Attribute;
import org.picketlink.idm.api.SortOrder;
import org.picketlink.idm.api.query.UserQuery;
import org.picketlink.idm.api.query.UserQueryBuilder;

public class IDMUserListAccess
implements ListAccess<User>,
Serializable {
    private static Logger log = LoggerFactory.getLogger(IDMUserListAccess.class);
    private final UserQueryBuilder userQueryBuilder;
    private final int pageSize;
    private final boolean countAll;
    private final UserStatus userStatus;
    private List<org.picketlink.idm.api.User> fullResults;
    private int size = -1;
    private User lastExisting;
    private boolean isDBOnly;

    public IDMUserListAccess(UserQueryBuilder userQueryBuilder, int pageSize, boolean countAll, boolean isDBOnly, UserStatus userStatus) {
        this.userQueryBuilder = userQueryBuilder;
        this.pageSize = pageSize;
        this.countAll = countAll;
        this.userStatus = userStatus;
        this.isDBOnly = isDBOnly;
    }

    public User[] load(int index, int length) throws Exception {
        if (log.isTraceEnabled()) {
            Tools.logMethodIn(log, LogLevel.TRACE, "load", new Object[]{"index", index, "length", length});
        }
        if (length == 0) {
            return new User[0];
        }
        int totalSize = this.getSize();
        if (index + length > totalSize) {
            throw new IllegalArgumentException("Try to get more than number users can retrieve");
        }
        Collection<Object> users = null;
        if (this.fullResults == null) {
            this.getOrganizationService().flush();
            this.userQueryBuilder.page(index, length);
            UserQuery query = this.userQueryBuilder.sort(SortOrder.ASCENDING).createQuery();
            users = this.getIDMService().getIdentitySession().list(query);
            if (!(this.userStatus != UserStatus.ENABLED && this.userStatus != UserStatus.DISABLED || this.isDBOnly)) {
                users = this.filterUserByStatus(users, this.userStatus, index, length);
            }
        } else {
            users = (this.userStatus == UserStatus.ENABLED || this.userStatus == UserStatus.DISABLED) && !this.isDBOnly ? this.filterUserByStatus(this.fullResults, this.userStatus, index, length) : this.fullResults.subList(index, index + length);
        }
        User[] exoUsers = new User[length];
        int i = 0;
        for (org.picketlink.idm.api.User user : users) {
            UserImpl gtnUser = new UserImpl(user.getId());
            ((UserDAOImpl)this.getOrganizationService().getUserHandler()).populateUser((User)gtnUser, this.getIDMService().getIdentitySession());
            exoUsers[i++] = gtnUser;
            this.lastExisting = gtnUser;
        }
        if (length > users.size()) {
            User[] additionalUsers;
            int additionalIndex = index + length;
            int additionalLength = length - users.size();
            if (additionalIndex + additionalLength > totalSize) {
                additionalLength = totalSize - additionalIndex;
            }
            if (additionalLength > 0 && (additionalUsers = this.load(additionalIndex, additionalLength)) != null) {
                for (User user : additionalUsers) {
                    if (user == null || !StringUtils.isNotBlank((String)user.getUserName())) continue;
                    exoUsers[i++] = user;
                }
            }
            while (i < length) {
                exoUsers[i++] = this.lastExisting;
            }
        }
        if (log.isTraceEnabled()) {
            Tools.logMethodOut(log, LogLevel.TRACE, "load", exoUsers);
        }
        return exoUsers;
    }

    public int getSize() throws Exception {
        int result;
        if (log.isTraceEnabled()) {
            Tools.logMethodIn(log, LogLevel.TRACE, "getSize", null);
        }
        this.getOrganizationService().flush();
        if (this.size < 0) {
            if (this.fullResults != null) {
                result = this.fullResults.size();
            } else if (this.countAll) {
                result = this.getIDMService().getIdentitySession().getPersistenceManager().getUserCount();
            } else {
                this.userQueryBuilder.page(0, 0);
                UserQuery query = this.userQueryBuilder.sort(SortOrder.ASCENDING).createQuery();
                this.fullResults = this.getIDMService().getIdentitySession().list(query);
                result = (this.userStatus == UserStatus.ENABLED || this.userStatus == UserStatus.DISABLED) && !this.isDBOnly ? this.filterUserByStatus(this.fullResults, this.userStatus, 0, this.fullResults.size()).size() : this.fullResults.size();
            }
            this.size = result;
        } else {
            result = this.size;
        }
        if (log.isTraceEnabled()) {
            Tools.logMethodOut(log, LogLevel.TRACE, "getSize", result);
        }
        return result;
    }

    PicketLinkIDMService getIDMService() {
        return (PicketLinkIDMService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(PicketLinkIDMService.class);
    }

    PicketLinkIDMOrganizationServiceImpl getOrganizationService() {
        return (PicketLinkIDMOrganizationServiceImpl)((Object)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(OrganizationService.class));
    }

    private Set<org.picketlink.idm.api.User> filterUserByStatus(Collection<org.picketlink.idm.api.User> fullResults, UserStatus userStatus, int index, int length) throws Exception {
        LinkedHashSet<org.picketlink.idm.api.User> result = new LinkedHashSet<org.picketlink.idm.api.User>();
        if (fullResults != null && fullResults.size() > 0) {
            int offset = 0;
            Iterator<org.picketlink.idm.api.User> iterator = fullResults.iterator();
            while (iterator.hasNext() && result.size() < length) {
                org.picketlink.idm.api.User user = iterator.next();
                Attribute attr = this.getIDMService().getIdentitySession().getAttributesManager().getAttribute(user.getKey(), "enabled");
                if ((userStatus != UserStatus.ENABLED || attr != null && !attr.getValue().toString().equals("true")) && (userStatus != UserStatus.DISABLED || attr == null || !attr.getValue().toString().equals("false"))) continue;
                if (this.fullResults == fullResults) {
                    if (offset >= index) {
                        result.add(user);
                    }
                    ++offset;
                    continue;
                }
                result.add(user);
            }
        }
        return result;
    }
}

