/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.idm;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.naming.InvalidNameException;
import org.exoplatform.commons.utils.ListenerStack;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.MembershipTypeEventListener;
import org.exoplatform.services.organization.MembershipTypeHandler;
import org.exoplatform.services.organization.idm.AbstractDAOImpl;
import org.exoplatform.services.organization.idm.PicketLinkIDMOrganizationServiceImpl;
import org.exoplatform.services.organization.idm.PicketLinkIDMService;
import org.exoplatform.services.organization.idm.Tools;
import org.exoplatform.services.organization.impl.MembershipTypeImpl;
import org.gatein.common.logging.LogLevel;
import org.picketlink.idm.api.RoleType;
import org.picketlink.idm.common.exception.IdentityException;

public class MembershipTypeDAOImpl
extends AbstractDAOImpl
implements MembershipTypeHandler {
    public static final String MEMBERSHIP_DESCRIPTION = "description";
    public static final String MEMBERSHIP_OWNER = "owner";
    public static final String MEMBERSHIP_CREATE_DATE = "create_date";
    public static final String MEMBERSHIP_MODIFIED_DATE = "modified_date";
    public static final DateFormat dateFormat = DateFormat.getInstance();
    private List listeners_ = new ListenerStack(5);

    public MembershipTypeDAOImpl(PicketLinkIDMOrganizationServiceImpl orgService, PicketLinkIDMService service) {
        super(orgService, service);
    }

    public void addMembershipTypeEventListener(MembershipTypeEventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        this.listeners_.add(listener);
    }

    public void removeMembershipTypeEventListener(MembershipTypeEventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        this.listeners_.remove(listener);
    }

    public final MembershipType createMembershipTypeInstance() {
        return new MembershipTypeImpl();
    }

    public MembershipType createMembershipType(MembershipType mt, boolean broadcast) throws Exception {
        if (this.log.isTraceEnabled()) {
            Tools.logMethodIn(this.log, LogLevel.TRACE, "createMembershipType", new Object[]{"membershipType", mt, "broadcast", broadcast});
        }
        Date now = new Date();
        mt.setCreatedDate(now);
        mt.setModifiedDate(now);
        if (broadcast) {
            this.preSave(mt, true);
        }
        if (this.getIdentitySession().getRoleManager().getRoleType(mt.getName()) != null) {
            throw new Exception("Membership type '" + mt.getName() + "' is already exists.");
        }
        try {
            this.getIdentitySession().getRoleManager().createRoleType(mt.getName());
        }
        catch (Exception e) {
            try {
                if (this.getIdentitySession().getRoleManager().getRoleType(mt.getName()) != null) {
                    this.getIdentitySession().getRoleManager().removeRoleType(mt.getName());
                }
            }
            catch (IdentityException e1) {
                this.handleException("Cannot remove roleType", (Exception)((Object)e1));
            }
            throw e;
        }
        if (broadcast) {
            this.postSave(mt, true);
        }
        this.updateMembershipType(mt);
        return mt;
    }

    public MembershipType saveMembershipType(MembershipType mt, boolean broadcast) throws Exception {
        if (this.log.isTraceEnabled()) {
            Tools.logMethodIn(this.log, LogLevel.TRACE, "saveMembershipType", new Object[]{"membershipType", mt, "broadcast", broadcast});
        }
        Date now = new Date();
        mt.setModifiedDate(now);
        if (broadcast) {
            this.preSave(mt, false);
        }
        this.updateMembershipType(mt);
        if (broadcast) {
            this.postSave(mt, false);
        }
        return mt;
    }

    public MembershipType findMembershipType(String name) throws Exception {
        if (this.log.isTraceEnabled()) {
            Tools.logMethodIn(this.log, LogLevel.TRACE, "findMembershipType", new Object[]{"name", name});
        }
        RoleType rt = null;
        try {
            rt = this.getIdentitySession().getRoleManager().getRoleType(name);
        }
        catch (Exception e) {
            this.handleException("Identity error when finding membership type " + name, e);
        }
        MembershipTypeImpl mt = null;
        if (rt != null) {
            mt = new MembershipTypeImpl(name, null, null);
            this.populateMembershipType((MembershipType)mt);
        }
        if (this.log.isTraceEnabled()) {
            Tools.logMethodOut(this.log, LogLevel.TRACE, "findMembershipType", mt);
        }
        return mt;
    }

    public MembershipType removeMembershipType(String name, boolean broadcast) throws Exception {
        MembershipType mt;
        if (this.log.isTraceEnabled()) {
            Tools.logMethodIn(this.log, LogLevel.TRACE, "removeMembershipType", new Object[]{"name", name, "broadcast", broadcast});
        }
        if ((mt = this.findMembershipType(name)) == null) {
            throw new InvalidNameException("Can not remove membership type" + name + "record, because membership type does not exist.");
        }
        if (mt != null) {
            if (broadcast) {
                this.preDelete(mt);
            }
            try {
                this.getIdentitySession().getRoleManager().removeRoleType(mt.getName());
            }
            catch (Exception e) {
                this.handleException("Error occured when removing membership type", e);
                throw e;
            }
            if (broadcast) {
                this.postDelete(mt);
            }
        }
        return mt;
    }

    public Collection<MembershipType> findMembershipTypes() throws Exception {
        LinkedList rts;
        if (this.log.isTraceEnabled()) {
            Tools.logMethodIn(this.log, LogLevel.TRACE, "findMembershipTypes", null);
        }
        try {
            rts = this.getIdentitySession().getRoleManager().findRoleTypes();
        }
        catch (Exception e) {
            this.handleException("Exception occured when looking for membership types", e);
            rts = new LinkedList();
        }
        LinkedList<MembershipType> mts = new LinkedList<MembershipType>();
        for (RoleType rt : rts) {
            MembershipTypeImpl mt = new MembershipTypeImpl(rt.getName(), null, null);
            this.populateMembershipType((MembershipType)mt);
            if (mt.getName().equals("*")) {
                mts.add(0, (MembershipType)mt);
                continue;
            }
            mts.add((MembershipType)mt);
        }
        if (this.log.isTraceEnabled()) {
            Tools.logMethodOut(this.log, LogLevel.TRACE, "findMembershipTypes", mts);
        }
        return mts;
    }

    private void updateMembershipType(MembershipType mt) throws Exception {
        RoleType rt;
        try {
            rt = this.getIdentitySession().getRoleManager().getRoleType(mt.getName());
        }
        catch (Exception e) {
            this.handleException("Exception occured when finding role type", e);
            throw e;
        }
        HashMap<String, String> props = new HashMap<String, String>();
        props.put(MEMBERSHIP_DESCRIPTION, mt.getDescription());
        props.put(MEMBERSHIP_CREATE_DATE, mt.getCreatedDate() == null ? null : "" + mt.getCreatedDate().getTime());
        props.put(MEMBERSHIP_MODIFIED_DATE, mt.getModifiedDate() == null ? null : "" + mt.getModifiedDate().getTime());
        props.put(MEMBERSHIP_OWNER, mt.getOwner());
        try {
            this.getIdentitySession().getRoleManager().setProperties(rt, props);
        }
        catch (Exception e) {
            this.handleException("Exception when updating membership type", e);
            throw e;
        }
    }

    private void populateMembershipType(MembershipType mt) throws Exception {
        long date;
        Map props;
        try {
            RoleType rt = this.getIdentitySession().getRoleManager().getRoleType(mt.getName());
            props = this.getIdentitySession().getRoleManager().getProperties(rt);
        }
        catch (Exception e) {
            this.handleException("Identity error occured when populating membership type", e);
            throw e;
        }
        mt.setDescription((String)props.get(MEMBERSHIP_DESCRIPTION));
        mt.setOwner((String)props.get(MEMBERSHIP_OWNER));
        String cd = (String)props.get(MEMBERSHIP_CREATE_DATE);
        String md = (String)props.get(MEMBERSHIP_MODIFIED_DATE);
        if (cd != null) {
            try {
                date = Long.parseLong(cd);
                mt.setCreatedDate(new Date(date));
            }
            catch (NumberFormatException e) {
                try {
                    mt.setCreatedDate(dateFormat.parse(cd));
                }
                catch (ParseException e2) {
                    this.log.error((Object)("Cannot parse the membership type creation date for: " + mt.getName()));
                }
            }
        }
        if (md != null) {
            try {
                date = Long.parseLong(md);
                mt.setModifiedDate(new Date(date));
            }
            catch (NumberFormatException e) {
                try {
                    mt.setModifiedDate(dateFormat.parse(md));
                }
                catch (ParseException e2) {
                    this.log.error((Object)("Cannot parse the membership type modification date for: " + mt.getName()));
                }
            }
        }
    }

    private void preSave(MembershipType membershipType, boolean isNew) throws Exception {
        for (int i = 0; i < this.listeners_.size(); ++i) {
            MembershipTypeEventListener listener = (MembershipTypeEventListener)this.listeners_.get(i);
            listener.preSave(membershipType, isNew);
        }
    }

    private void postSave(MembershipType membershipType, boolean isNew) throws Exception {
        for (int i = 0; i < this.listeners_.size(); ++i) {
            MembershipTypeEventListener listener = (MembershipTypeEventListener)this.listeners_.get(i);
            listener.postSave(membershipType, isNew);
        }
    }

    private void preDelete(MembershipType membershipType) throws Exception {
        for (int i = 0; i < this.listeners_.size(); ++i) {
            MembershipTypeEventListener listener = (MembershipTypeEventListener)this.listeners_.get(i);
            listener.preDelete(membershipType);
        }
    }

    private void postDelete(MembershipType membershipType) throws Exception {
        for (int i = 0; i < this.listeners_.size(); ++i) {
            MembershipTypeEventListener listener = (MembershipTypeEventListener)this.listeners_.get(i);
            listener.postDelete(membershipType);
        }
    }
}

