/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.pc;

import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.pc.ExoPortletApplicationDeployer;
import org.exoplatform.portal.pc.ExoStateConverter;
import org.exoplatform.portal.pc.aspects.PortletLifecyclePhaseInterceptor;
import org.exoplatform.services.resources.ResourceBundleService;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.pc.api.PortletInvoker;
import org.gatein.pc.bridge.BridgeInterceptor;
import org.gatein.pc.federation.FederatingPortletInvoker;
import org.gatein.pc.federation.impl.FederatingPortletInvokerService;
import org.gatein.pc.portlet.PortletInvokerInterceptor;
import org.gatein.pc.portlet.aspects.CCPPInterceptor;
import org.gatein.pc.portlet.aspects.ConsumerCacheInterceptor;
import org.gatein.pc.portlet.aspects.ContextDispatcherInterceptor;
import org.gatein.pc.portlet.aspects.EventPayloadInterceptor;
import org.gatein.pc.portlet.aspects.PortletCustomizationInterceptor;
import org.gatein.pc.portlet.aspects.ProducerCacheInterceptor;
import org.gatein.pc.portlet.aspects.RequestAttributeConversationInterceptor;
import org.gatein.pc.portlet.aspects.SecureTransportInterceptor;
import org.gatein.pc.portlet.aspects.SessionInvalidatorInterceptor;
import org.gatein.pc.portlet.aspects.ValveInterceptor;
import org.gatein.pc.portlet.container.ContainerPortletDispatcher;
import org.gatein.pc.portlet.container.ContainerPortletInvoker;
import org.gatein.pc.portlet.container.managed.PortletApplicationRegistry;
import org.gatein.pc.portlet.impl.deployment.DeploymentException;
import org.gatein.pc.portlet.impl.deployment.PortletApplicationDeployer;
import org.gatein.pc.portlet.impl.state.StateManagementPolicyService;
import org.gatein.pc.portlet.impl.state.producer.PortletStatePersistenceManagerService;
import org.gatein.pc.portlet.state.StateConverter;
import org.gatein.pc.portlet.state.StateManagementPolicy;
import org.gatein.pc.portlet.state.producer.PortletStatePersistenceManager;
import org.gatein.pc.portlet.state.producer.ProducerPortletInvoker;
import org.gatein.wci.ServletContainerFactory;
import org.gatein.wci.WebAppEvent;
import org.gatein.wci.WebAppLifeCycleEvent;
import org.gatein.wci.WebAppListener;
import org.picocontainer.Startable;

public class ExoKernelIntegration
implements Startable,
WebAppListener {
    protected PortletApplicationDeployer portletApplicationRegistry;
    private final ExoContainer container;
    private final ResourceBundleService resourceBundleService;
    private boolean producerPortletInvokerSet;
    private Logger log = LoggerFactory.getLogger(ExoKernelIntegration.class);

    public ExoKernelIntegration(ExoContainerContext context, ResourceBundleService resourceBundleService) {
        this.container = context.getContainer();
        this.resourceBundleService = resourceBundleService;
    }

    public void start() {
        ContainerPortletInvoker containerPortletInvoker = new ContainerPortletInvoker();
        this.portletApplicationRegistry = new ExoPortletApplicationDeployer();
        this.portletApplicationRegistry.setContainerPortletInvoker(containerPortletInvoker);
        String validation = PropertyManager.getProperty((String)"gatein.portlet.validation");
        boolean validated = validation == null || "true".equals(validation.trim().toLowerCase());
        this.log.debug((Object)("portlet xml validation is " + (validated ? "enabled" : " disabled")));
        this.portletApplicationRegistry.setSchemaValidated(validated);
        ContainerPortletDispatcher portletContainerDispatcher = new ContainerPortletDispatcher();
        FederatingPortletInvokerService federatingPortletInvoker = new FederatingPortletInvokerService();
        EventPayloadInterceptor eventPayloadInterceptor = new EventPayloadInterceptor();
        eventPayloadInterceptor.setNext((PortletInvoker)portletContainerDispatcher);
        RequestAttributeConversationInterceptor requestAttributeConversationInterceptor = new RequestAttributeConversationInterceptor();
        requestAttributeConversationInterceptor.setNext((PortletInvoker)eventPayloadInterceptor);
        CCPPInterceptor ccppInterceptor = new CCPPInterceptor();
        ccppInterceptor.setNext((PortletInvoker)requestAttributeConversationInterceptor);
        BridgeInterceptor bridgepInterceptor = new BridgeInterceptor();
        bridgepInterceptor.setNext((PortletInvoker)ccppInterceptor);
        ProducerCacheInterceptor producerCacheInterceptor = new ProducerCacheInterceptor();
        producerCacheInterceptor.setNext((PortletInvoker)bridgepInterceptor);
        SessionInvalidatorInterceptor sessionInvalidatorInterceptor = new SessionInvalidatorInterceptor();
        sessionInvalidatorInterceptor.setNext((PortletInvoker)producerCacheInterceptor);
        ContextDispatcherInterceptor contextDispatcherInterceptor = new ContextDispatcherInterceptor();
        contextDispatcherInterceptor.setNext((PortletInvoker)sessionInvalidatorInterceptor);
        PortletLifecyclePhaseInterceptor portletLifecyclePhaseInterceptor = new PortletLifecyclePhaseInterceptor();
        portletLifecyclePhaseInterceptor.setNext((PortletInvoker)contextDispatcherInterceptor);
        SecureTransportInterceptor secureTransportInterceptor = new SecureTransportInterceptor();
        secureTransportInterceptor.setNext((PortletInvoker)portletLifecyclePhaseInterceptor);
        ValveInterceptor valveInterceptor = new ValveInterceptor();
        valveInterceptor.setPortletApplicationRegistry((PortletApplicationRegistry)this.portletApplicationRegistry);
        valveInterceptor.setNext((PortletInvoker)secureTransportInterceptor);
        containerPortletInvoker.setNext((PortletInvoker)valveInterceptor);
        this.container.registerComponentInstance(ContainerPortletInvoker.class, (Object)containerPortletInvoker);
        PortletStatePersistenceManagerService producerPersistenceManager = new PortletStatePersistenceManagerService();
        StateManagementPolicyService producerStateManagementPolicy = new StateManagementPolicyService();
        producerStateManagementPolicy.setPersistLocally(false);
        ExoStateConverter producerStateConverter = new ExoStateConverter();
        ProducerPortletInvoker producerPortletInvoker = new ProducerPortletInvoker();
        producerPortletInvoker.setNext((PortletInvoker)containerPortletInvoker);
        producerPortletInvoker.setPersistenceManager((PortletStatePersistenceManager)producerPersistenceManager);
        producerPortletInvoker.setStateManagementPolicy((StateManagementPolicy)producerStateManagementPolicy);
        producerPortletInvoker.setStateConverter((StateConverter)producerStateConverter);
        if (!federatingPortletInvoker.isResolved("local")) {
            federatingPortletInvoker.registerInvoker("local", (PortletInvoker)producerPortletInvoker);
            this.producerPortletInvokerSet = true;
        }
        PortletCustomizationInterceptor portletCustomizationInterceptor = new PortletCustomizationInterceptor();
        portletCustomizationInterceptor.setNext((PortletInvoker)federatingPortletInvoker);
        ConsumerCacheInterceptor consumerCacheInterceptor = new ConsumerCacheInterceptor();
        consumerCacheInterceptor.setNext((PortletInvoker)portletCustomizationInterceptor);
        PortletInvokerInterceptor consumerPortletInvoker = new PortletInvokerInterceptor();
        consumerPortletInvoker.setNext((PortletInvoker)consumerCacheInterceptor);
        this.container.registerComponentInstance(PortletInvoker.class, (Object)consumerPortletInvoker);
        this.container.registerComponentInstance(FederatingPortletInvoker.class, (Object)federatingPortletInvoker);
        ServletContainerFactory.getServletContainer().addWebAppListener((WebAppListener)this);
    }

    public void stop() {
        ServletContainerFactory.getServletContainer().removeWebAppListener((WebAppListener)this);
        if (!this.producerPortletInvokerSet || !PropertyManager.isDevelopping()) {
            return;
        }
        ExoContainer topContainer = ExoContainerContext.getTopContainer();
        FederatingPortletInvoker federatingPortletInvoker = (FederatingPortletInvoker)topContainer.getComponentInstanceOfType(FederatingPortletInvoker.class);
        if (federatingPortletInvoker != null && federatingPortletInvoker.isResolved("local")) {
            federatingPortletInvoker.unregisterInvoker("local");
        }
    }

    public PortletApplicationDeployer getPortletApplicationRegistry() {
        return this.portletApplicationRegistry;
    }

    public void onEvent(WebAppEvent event) {
        if (event instanceof WebAppLifeCycleEvent) {
            WebAppLifeCycleEvent lifeCycleEvent = (WebAppLifeCycleEvent)event;
            int type = lifeCycleEvent.getType();
            if (type == 1) {
                try {
                    this.portletApplicationRegistry.add(lifeCycleEvent.getWebApp().getServletContext());
                }
                catch (DeploymentException e) {
                    this.log.error((Object)"Portlet deployment failed", (Throwable)e);
                }
            } else if (type == 0) {
                this.portletApplicationRegistry.remove(lifeCycleEvent.getWebApp().getServletContext());
            }
        }
    }
}

