/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.resources.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.MapResourceBundle;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.resources.ExoResourceBundle;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.resources.Query;
import org.exoplatform.services.resources.ResourceBundleData;
import org.exoplatform.services.resources.impl.BaseResourceBundleService;

public class SimpleResourceBundleService
extends BaseResourceBundleService {
    private final ConcurrentMap<String, ResourceBundleData> bundles = new ConcurrentHashMap<String, ResourceBundleData>();

    public SimpleResourceBundleService(PortalContainer portalContainer, InitParams params, CacheService cService, LocaleConfigService localeService) throws Exception {
        this.log_ = ExoLogger.getLogger((String)"org.exoplatform.services.resources");
        this.localeService_ = localeService;
        this.cache_ = cService.getCacheInstance(ResourceBundleData.class.getSimpleName());
        this.portalContainer_ = portalContainer;
        this.initParams(params);
    }

    @Override
    public ResourceBundleData getResourceBundleData(String id) {
        return (ResourceBundleData)this.bundles.get(id);
    }

    @Override
    public ResourceBundleData removeResourceBundleData(String id) {
        if (id == null) {
            return null;
        }
        ResourceBundleData data = (ResourceBundleData)this.bundles.remove(id);
        this.invalidate(id);
        return data;
    }

    @Override
    public void saveResourceBundle(ResourceBundleData resourceData) {
        String id = resourceData.getId();
        this.bundles.put(id, resourceData);
        this.invalidate(id);
    }

    @Override
    public PageList<ResourceBundleData> findResourceDescriptions(Query q) {
        final ArrayList<ResourceBundleData> list = new ArrayList<ResourceBundleData>();
        for (ResourceBundleData data : this.bundles.values()) {
            boolean matches = true;
            if (q.getName() != null) {
                matches &= q.getName().equals(data.getName());
            }
            if (q.getLanguage() != null) {
                matches &= q.getLanguage().equals(data.getLanguage());
            }
            if (!matches) continue;
            list.add(data);
        }
        Collections.sort(list, new Comparator<ResourceBundleData>(){

            @Override
            public int compare(ResourceBundleData o1, ResourceBundleData o2) {
                String l1 = o1.getLanguage();
                String l2 = o2.getLanguage();
                if (l1 == null) {
                    return l2 == null ? 0 : 1;
                }
                return l1.compareTo(l2);
            }
        });
        return new LazyPageList((ListAccess)new ListAccess<ResourceBundleData>(){

            public ResourceBundleData[] load(int index, int length) throws Exception {
                List sub = list.subList(index, index + length);
                return sub.toArray(new ResourceBundleData[sub.size()]);
            }

            public int getSize() throws Exception {
                return list.size();
            }
        }, 20);
    }

    @Override
    protected ResourceBundle getResourceBundleFromDb(String id, ResourceBundle parent, Locale locale) throws Exception {
        ResourceBundleData data = this.getResourceBundleData(id);
        if (data == null) {
            return null;
        }
        return new MapResourceBundle((ResourceBundle)new ExoResourceBundle(data, parent), locale);
    }
}

