/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.resources;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.ExoResourceBundle;
import org.exoplatform.services.resources.InputStreamURLStreamHandler;
import org.exoplatform.services.resources.XMLResourceBundleParser;

public class PropertiesClassLoader
extends ClassLoader {
    private static final Log LOG = ExoLogger.getLogger(PropertiesClassLoader.class);
    private boolean unicode;

    public PropertiesClassLoader(ClassLoader parent) {
        this(parent, false);
    }

    public PropertiesClassLoader(ClassLoader parent, boolean unicode) {
        super(parent);
        this.unicode = unicode;
    }

    public PropertiesClassLoader() {
    }

    @Override
    public URL getResource(String name) {
        if (name.endsWith(".properties")) {
            URL url = null;
            for (ClassLoader parent = this.getParent(); parent != null; parent = parent.getParent()) {
                url = PropertiesClassLoader.getResource(parent, name, this.unicode);
                if (url == null) continue;
                return url;
            }
            if (url == null) {
                url = PropertiesClassLoader.getResource(this, name, this.unicode);
            }
            return url;
        }
        return super.getResource(name);
    }

    private static URL getResource(ClassLoader cl, String name, boolean unicode) {
        String xmlName = name.substring(0, name.length() - ".properties".length()) + ".xml";
        URL url = PropertiesClassLoader.getResource(cl, xmlName, unicode, true);
        if (url == null) {
            url = PropertiesClassLoader.getResource(cl, name, unicode, false);
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static URL getResource(ClassLoader cl, String name, boolean unicode, boolean xml) {
        Enumeration<URL> urls = null;
        try {
            urls = cl.getResources(name);
        }
        catch (Exception e) {
            LOG.error((Object)("An error occured while seeking all the resources with the name " + name), (Throwable)e);
            return null;
        }
        if (urls != null && urls.hasMoreElements()) {
            Object in;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            URL url = null;
            Map props = unicode ? new TreeMap() : new Properties();
            while (urls.hasMoreElements()) {
                url = urls.nextElement();
                in = null;
                try {
                    in = url.openStream();
                    if (xml) {
                        props.putAll(XMLResourceBundleParser.asProperties((InputStream)in));
                        continue;
                    }
                    byte[] byArray = IOUtil.getStreamContentAsBytes((InputStream)in);
                    ExoResourceBundle bundle = new ExoResourceBundle(new String(byArray, "UTF-8"));
                    bundle.putAll(props);
                }
                catch (Exception exception) {
                    LOG.error((Object)("An error occured while loading the content of " + url), (Throwable)exception);
                    URL uRL = null;
                    return uRL;
                }
                finally {
                    if (in == null) continue;
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException iOException) {}
                }
            }
            try {
                if (unicode) {
                    for (Map.Entry entry : props.entrySet()) {
                        out.write(((String)entry.getKey()).getBytes("UTF-8"));
                        out.write(61);
                        out.write(((String)entry.getValue()).getBytes("UTF-8"));
                        out.write(10);
                    }
                } else {
                    ((Properties)props).store(out, null);
                }
                out.close();
                in = new ByteArrayInputStream(out.toByteArray());
                return new URL(url, "", new InputStreamURLStreamHandler((InputStream)in));
            }
            catch (Exception e) {
                LOG.error((Object)("An error occured while creating the content of " + url), (Throwable)e);
                return null;
            }
        }
        return null;
    }
}

