/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.groovyscript;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;
import java.util.Map;
import org.exoplatform.groovyscript.GroovyScript;
import org.exoplatform.groovyscript.GroovyScriptBuilder;
import org.exoplatform.groovyscript.TemplateCompilationException;
import org.exoplatform.groovyscript.TemplateRuntimeException;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

public class GroovyTemplate
implements Serializable {
    private static final long serialVersionUID = -8220112880199970451L;
    private final String templateText;
    private final String templateId;
    private final String templateName;
    private transient GroovyScript script;

    private static String read(Reader reader) throws IOException {
        StringBuilder builder = new StringBuilder();
        char[] chars = new char[256];
        int s = reader.read(chars);
        while (s != -1) {
            builder.append(chars, 0, s);
            s = reader.read(chars);
        }
        return builder.toString();
    }

    public GroovyTemplate(String id, String name, Reader scriptReader) throws IOException, TemplateCompilationException {
        this(id, name, GroovyTemplate.read(scriptReader));
    }

    public GroovyTemplate(Reader scriptReader) throws IOException, TemplateCompilationException {
        this(GroovyTemplate.read(scriptReader));
    }

    public GroovyTemplate(String templateText) throws TemplateCompilationException {
        this(null, null, templateText);
    }

    public GroovyTemplate(String templateId, String templateName, String templateText) throws TemplateCompilationException {
        templateName = templateName == null ? "fic" : templateName.replaceAll("-", "_");
        GroovyScriptBuilder compiler = new GroovyScriptBuilder(templateId, templateName, templateText);
        this.script = compiler.build();
        this.templateText = templateText;
        this.templateId = templateId;
        this.templateName = templateName;
    }

    public String getId() {
        return this.templateId;
    }

    public String getClassName() {
        return this.getScript().getScriptClass().getName();
    }

    public String getText() {
        return this.templateText;
    }

    public String getGroovy() {
        return this.getScript().getGroovyText();
    }

    public void render(Writer writer) throws IOException, TemplateRuntimeException {
        this.render(writer, (Map)null);
    }

    public void render(Writer writer, Locale locale) throws IOException, TemplateRuntimeException {
        this.render(writer, null, locale);
    }

    public void render(Writer writer, Map binding, Locale locale) throws IOException, TemplateRuntimeException {
        this.getScript().render(binding, writer, locale);
    }

    public void render(Writer writer, Map binding) throws IOException, TemplateRuntimeException {
        this.getScript().render(binding, writer, null);
    }

    public String render() throws IOException, TemplateRuntimeException {
        return this.render((Map)null);
    }

    public String render(Locale locale) throws IOException, TemplateRuntimeException {
        return this.render((Map)null, locale);
    }

    public String render(Map binding) throws IOException, TemplateRuntimeException {
        return this.render(binding, null);
    }

    public String render(Map binding, Locale locale) throws IOException, TemplateRuntimeException {
        StringWriter buffer = new StringWriter();
        this.render(buffer, binding, locale);
        buffer.close();
        return buffer.toString();
    }

    private GroovyScript getScript() {
        if (this.script == null) {
            try {
                GroovyScriptBuilder compiler = new GroovyScriptBuilder(this.templateId, this.templateName, this.templateText);
                this.script = compiler.build();
            }
            catch (TemplateCompilationException ex) {
                Logger log = LoggerFactory.getLogger(GroovyTemplate.class);
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        return this.script;
    }
}

