/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.groovyscript;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;
import java.util.Map;
import org.exoplatform.groovyscript.GroovyScript;
import org.exoplatform.groovyscript.GroovyScriptBuilder;
import org.exoplatform.groovyscript.TemplateCompilationException;
import org.exoplatform.groovyscript.TemplateRuntimeException;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

public class GroovyTemplate
implements Externalizable {
    private static final long serialVersionUID = -8220112880199970451L;
    private static final String DEFAULT_ENCODING = "UTF-8";
    private String templateText;
    private String templateId;
    private String templateName;
    private volatile GroovyScript script;

    private static String read(Reader reader) throws IOException {
        StringBuilder builder = new StringBuilder();
        char[] chars = new char[256];
        int s = reader.read(chars);
        while (s != -1) {
            builder.append(chars, 0, s);
            s = reader.read(chars);
        }
        return builder.toString();
    }

    public GroovyTemplate() {
    }

    public GroovyTemplate(String id, String name, Reader scriptReader) throws IOException, TemplateCompilationException {
        this(id, name, GroovyTemplate.read(scriptReader));
    }

    public GroovyTemplate(Reader scriptReader) throws IOException, TemplateCompilationException {
        this(GroovyTemplate.read(scriptReader));
    }

    public GroovyTemplate(String templateText) throws TemplateCompilationException {
        this(null, null, templateText);
    }

    public GroovyTemplate(String templateId, String templateName, String templateText) throws TemplateCompilationException {
        templateName = templateName == null ? "fic" : templateName.replaceAll("-", "_");
        GroovyScriptBuilder compiler = new GroovyScriptBuilder(templateId, templateName, templateText);
        this.script = compiler.build();
        this.templateText = templateText;
        this.templateId = templateId;
        this.templateName = templateName;
    }

    public String getId() {
        return this.templateId;
    }

    public String getClassName() {
        return this.getScript().getScriptClass().getName();
    }

    public String getText() {
        return this.templateText;
    }

    public String getGroovy() {
        return this.getScript().getGroovyText();
    }

    public void render(Writer writer) throws IOException, TemplateRuntimeException {
        this.render(writer, (Map)null);
    }

    public void render(Writer writer, Locale locale) throws IOException, TemplateRuntimeException {
        this.render(writer, null, locale);
    }

    public void render(Writer writer, Map binding, Locale locale) throws IOException, TemplateRuntimeException {
        this.getScript().render(binding, writer, locale);
    }

    public void render(Writer writer, Map binding) throws IOException, TemplateRuntimeException {
        this.getScript().render(binding, writer, null);
    }

    public String render() throws IOException, TemplateRuntimeException {
        return this.render((Map)null);
    }

    public String render(Locale locale) throws IOException, TemplateRuntimeException {
        return this.render((Map)null, locale);
    }

    public String render(Map binding) throws IOException, TemplateRuntimeException {
        return this.render(binding, null);
    }

    public String render(Map binding, Locale locale) throws IOException, TemplateRuntimeException {
        StringWriter buffer = new StringWriter();
        this.render(buffer, binding, locale);
        buffer.close();
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GroovyScript getScript() {
        if (this.script == null) {
            GroovyTemplate groovyTemplate = this;
            synchronized (groovyTemplate) {
                if (this.script == null) {
                    try {
                        GroovyScriptBuilder compiler = new GroovyScriptBuilder(this.templateId, this.templateName, this.templateText);
                        this.script = compiler.build();
                    }
                    catch (TemplateCompilationException ex) {
                        Logger log = LoggerFactory.getLogger(GroovyTemplate.class);
                        log.error((Object)ex.getMessage(), (Throwable)ex);
                    }
                }
            }
        }
        return this.script;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        byte[] bytes = this.templateId.getBytes(DEFAULT_ENCODING);
        out.writeInt(bytes.length);
        out.write(bytes);
        bytes = this.templateName.getBytes(DEFAULT_ENCODING);
        out.writeInt(bytes.length);
        out.write(bytes);
        bytes = this.templateText.getBytes(DEFAULT_ENCODING);
        out.writeInt(bytes.length);
        out.write(bytes);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte[] bytes = new byte[in.readInt()];
        in.readFully(bytes);
        this.templateId = new String(bytes, DEFAULT_ENCODING);
        bytes = new byte[in.readInt()];
        in.readFully(bytes);
        this.templateName = new String(bytes, DEFAULT_ENCODING);
        bytes = new byte[in.readInt()];
        in.readFully(bytes);
        this.templateText = new String(bytes, DEFAULT_ENCODING);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.templateId == null ? 0 : this.templateId.hashCode());
        result = 31 * result + (this.templateName == null ? 0 : this.templateName.hashCode());
        result = 31 * result + (this.templateText == null ? 0 : this.templateText.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GroovyTemplate other = (GroovyTemplate)obj;
        if (this.templateId == null ? other.templateId != null : !this.templateId.equals(other.templateId)) {
            return false;
        }
        if (this.templateName == null ? other.templateName != null : !this.templateName.equals(other.templateName)) {
            return false;
        }
        return !(this.templateText == null ? other.templateText != null : !this.templateText.equals(other.templateText));
    }
}

