/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.groovyscript.text;

import groovy.lang.Writable;
import groovy.text.Template;
import java.io.Closeable;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.cache.future.FutureCache;
import org.exoplatform.commons.cache.future.FutureExoCache;
import org.exoplatform.commons.cache.future.Loader;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.groovyscript.GroovyTemplate;
import org.exoplatform.groovyscript.GroovyTemplateEngine;
import org.exoplatform.groovyscript.text.BindingContext;
import org.exoplatform.groovyscript.text.TemplateStatistic;
import org.exoplatform.groovyscript.text.TemplateStatisticService;
import org.exoplatform.management.annotations.Impact;
import org.exoplatform.management.annotations.ImpactType;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.annotations.ManagedName;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.management.rest.annotations.RESTEndpoint;
import org.exoplatform.resolver.ResourceKey;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.gatein.common.io.IOTools;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.picocontainer.Startable;

@Managed
@NameTemplate(value={@Property(key="view", value="portal"), @Property(key="service", value="management"), @Property(key="type", value="template")})
@ManagedDescription(value="Template management service")
@RESTEndpoint(path="templateservice")
public class TemplateService
implements Startable {
    private ExecutorService executorService = Executors.newCachedThreadPool();
    private GroovyTemplateEngine engine_;
    private ExoCache<ResourceKey, GroovyTemplate> templatesCache_;
    private TemplateStatisticService statisticService;
    private boolean cacheTemplate_ = true;
    private boolean collectTemplateStatistics_ = true;
    private final Loader<ResourceKey, GroovyTemplate, ResourceResolver> loader = new Loader<ResourceKey, GroovyTemplate, ResourceResolver>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public GroovyTemplate retrieve(ResourceResolver context, ResourceKey key) throws Exception {
            byte[] bytes;
            InputStream is = context.getInputStream(key.getURL());
            try {
                bytes = IOUtil.getStreamContentAsBytes((InputStream)is);
                is.close();
            }
            finally {
                IOTools.safeClose((Closeable)is);
            }
            int pos = key.getURL().lastIndexOf(47);
            if (pos == -1) {
                pos = 0;
            }
            String name = key.getURL().substring(pos);
            String text = new String(bytes);
            return TemplateService.this.engine_.createTemplate(key.getURL(), name, text);
        }
    };
    private FutureCache<ResourceKey, GroovyTemplate, ResourceResolver> futureCache;
    private final Logger log = LoggerFactory.getLogger(TemplateService.class);

    public TemplateService(TemplateStatisticService statisticService, CacheService cservice, InitParams initParams) throws Exception {
        ValueParam valueParam;
        this.engine_ = new GroovyTemplateEngine();
        this.statisticService = statisticService;
        this.templatesCache_ = cservice.getCacheInstance(TemplateService.class.getSimpleName());
        this.futureCache = new FutureExoCache(this.loader, this.templatesCache_);
        if (initParams != null && (valueParam = initParams.getValueParam("templates.collect.statistics")) != null && StringUtils.isNotBlank((String)valueParam.getValue())) {
            this.collectTemplateStatistics_ = Boolean.valueOf(valueParam.getValue());
        }
    }

    public void merge(String name, BindingContext context) throws Exception {
        long startTime = System.currentTimeMillis();
        GroovyTemplate template = this.getTemplate(name, context.getResourceResolver());
        context.put("_ctx", context);
        context.setGroovyTemplateService(this);
        template.render(context.getWriter(), context, (Locale)context.get("locale"));
        long endTime = System.currentTimeMillis();
        if (this.collectTemplateStatistics_) {
            final ResourceResolver resourceResolver = context.getResourceResolver();
            final Long time = endTime - startTime;
            final TemplateStatistic templateStatistic = this.statisticService.getTemplateStatistic(name);
            this.executorService.execute(new Runnable(){

                @Override
                public void run() {
                    templateStatistic.setResolver(resourceResolver);
                    templateStatistic.setTime(time);
                }
            });
        }
    }

    @Deprecated
    public void merge(Template template, BindingContext context) throws Exception {
        context.put("_ctx", context);
        context.setGroovyTemplateService(this);
        Writable writable = template.make((Map)context);
        writable.writeTo(context.getWriter());
    }

    public void include(String name, BindingContext context) throws Exception {
        if (context == null) {
            throw new Exception("Binding cannot be null");
        }
        context.put("_ctx", context);
        GroovyTemplate template = this.getTemplate(name, context.getResourceResolver());
        template.render(context.getWriter(), context, (Locale)context.get("locale"));
    }

    public final GroovyTemplate getTemplate(String name, ResourceResolver resolver) throws Exception {
        return this.getTemplate(name, resolver, this.cacheTemplate_);
    }

    public final GroovyTemplate getTemplate(String url, ResourceResolver resolver, boolean cacheable) throws Exception {
        ResourceKey resourceId = resolver.createResourceKey(url);
        GroovyTemplate template = cacheable ? (GroovyTemplate)this.futureCache.get((Object)resolver, (Object)resourceId) : (GroovyTemplate)this.loader.retrieve((Object)resolver, (Object)resourceId);
        return template;
    }

    public final void invalidateTemplate(String name, ResourceResolver resolver) {
        ResourceKey resourceKey = resolver.createResourceKey(name);
        this.getTemplatesCache().remove((Serializable)resourceKey);
    }

    public ExoCache<ResourceKey, GroovyTemplate> getTemplatesCache() {
        return this.templatesCache_;
    }

    @Managed
    @ManagedDescription(value="Enable collecting templates statistics")
    public void enableStatistics(boolean enable) {
        this.collectTemplateStatistics_ = enable;
    }

    @Managed
    @ManagedDescription(value="Clear the template cache")
    public void reloadTemplates() {
        try {
            this.templatesCache_.clearCache();
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Managed
    @ManagedDescription(value="Clear the template cache for a specified template identifier")
    @Impact(value=ImpactType.IDEMPOTENT_WRITE)
    public void reloadTemplate(@ManagedDescription(value="The template id") @ManagedName(value="templateId") String name) {
        TemplateStatistic app = this.statisticService.findTemplateStatistic(name);
        if (app != null) {
            ResourceResolver resolver = app.getResolver();
            this.templatesCache_.remove((Serializable)resolver.createResourceKey(name));
        }
    }

    @Managed
    @ManagedDescription(value="List the identifiers of the cached templates")
    @Impact(value=ImpactType.READ)
    public String[] listCachedTemplates() {
        try {
            ArrayList<String> list = new ArrayList<String>();
            for (GroovyTemplate template : this.templatesCache_.getCachedObjects()) {
                list.add(template.getId());
            }
            return list.toArray(new String[list.size()]);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void start() {
    }

    public void stop() {
        this.executorService.shutdown();
    }
}

