/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.controller.router;

import java.io.IOException;
import java.util.List;
import org.exoplatform.web.controller.QualifiedName;
import org.exoplatform.web.controller.metadata.PathParamDescriptor;
import org.exoplatform.web.controller.regexp.RENode;
import org.exoplatform.web.controller.regexp.REParser;
import org.exoplatform.web.controller.regexp.RERenderer;
import org.exoplatform.web.controller.regexp.REVisitor;
import org.exoplatform.web.controller.regexp.SyntaxException;
import org.exoplatform.web.controller.router.CaptureGroupTransformation;
import org.exoplatform.web.controller.router.CharEscapeTransformation;
import org.exoplatform.web.controller.router.EncodingMode;
import org.exoplatform.web.controller.router.MalformedRouteException;
import org.exoplatform.web.controller.router.NonCaptureGroupTransformation;
import org.exoplatform.web.controller.router.Param;
import org.exoplatform.web.controller.router.Regex;
import org.exoplatform.web.controller.router.Router;
import org.exoplatform.web.controller.router.ValueResolverFactory;

class PathParam
extends Param {
    final EncodingMode encodingMode;
    final String routingRegex;
    final Regex[] matchingRegex;
    final String[] templatePrefixes;
    final String[] templateSuffixes;

    static PathParam create(QualifiedName name, Router router) {
        return PathParam.create(new PathParamDescriptor(name), router);
    }

    static PathParam create(PathParamDescriptor descriptor, Router router) {
        String[] templateSuffixes;
        String[] templatePrefixes;
        Regex[] renderingRegexes;
        if (descriptor == null) {
            throw new NullPointerException("No null descriptor accepted");
        }
        String regex = null;
        EncodingMode encodingMode = EncodingMode.FORM;
        if (descriptor != null) {
            regex = descriptor.getPattern();
            encodingMode = descriptor.getEncodingMode();
        }
        if (regex == null) {
            regex = encodingMode == EncodingMode.FORM ? ".+" : "[^/]+";
        }
        StringBuilder routingRegex = new StringBuilder();
        try {
            REVisitor transformer = descriptor.getCaptureGroup() ? new CaptureGroupTransformation() : new NonCaptureGroupTransformation();
            REParser parser = new REParser(regex);
            RENode.Disjunction routingDisjunction = parser.parseDisjunction();
            if (encodingMode == EncodingMode.FORM) {
                CharEscapeTransformation escaper = new CharEscapeTransformation('/', '_');
                routingDisjunction.accept(escaper);
            }
            routingDisjunction.accept(transformer);
            RERenderer.render(routingDisjunction, routingRegex);
            parser.reset();
            RENode.Disjunction renderingDisjunction = parser.parseDisjunction();
            ValueResolverFactory factory = new ValueResolverFactory();
            renderingDisjunction.accept(transformer);
            List<ValueResolverFactory.Alternative> alt = factory.foo(renderingDisjunction);
            renderingRegexes = new Regex[alt.size()];
            templatePrefixes = new String[alt.size()];
            templateSuffixes = new String[alt.size()];
            for (int i = 0; i < alt.size(); ++i) {
                ValueResolverFactory.Alternative v = alt.get(i);
                StringBuilder valueMatcher = v.getValueMatcher();
                valueMatcher.insert(0, '^');
                valueMatcher.append("$");
                renderingRegexes[i] = router.compile(valueMatcher.toString());
                templatePrefixes[i] = v.getPrefix();
                templateSuffixes[i] = v.getSuffix();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (SyntaxException e) {
            throw new RuntimeException(e);
        }
        catch (MalformedRouteException e) {
            throw new RuntimeException(e);
        }
        return new PathParam(descriptor.getQualifiedName(), encodingMode, routingRegex.toString(), renderingRegexes, templatePrefixes, templateSuffixes);
    }

    private PathParam(QualifiedName name, EncodingMode encodingMode, String routingRegex, Regex[] matchingRegex, String[] templatePrefixes, String[] templateSuffixes) {
        super(name);
        if (matchingRegex == null || matchingRegex.length == 0) {
            throw new NullPointerException("No null or empty pattern accepted");
        }
        this.encodingMode = encodingMode;
        this.routingRegex = routingRegex;
        this.matchingRegex = matchingRegex;
        this.templatePrefixes = templatePrefixes;
        this.templateSuffixes = templateSuffixes;
    }

    public String toString() {
        return "PathParam[name=" + this.name + ",encodingMode=" + (Object)((Object)this.encodingMode) + ",pattern=" + this.matchingRegex + "]";
    }
}

