/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web;

import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.controller.QualifiedName;
import org.exoplatform.web.controller.router.RenderContext;
import org.exoplatform.web.controller.router.Router;
import org.exoplatform.web.controller.router.URIWriter;

public class ControllerContext {
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final WebAppController controller;
    private final Router router;
    private final Map<QualifiedName, String> parameters;
    private final String contextName;
    private final RenderContext renderContext;

    public ControllerContext(WebAppController controller, Router router, HttpServletRequest request, HttpServletResponse response, Map<QualifiedName, String> parameters) {
        this.controller = controller;
        this.request = request;
        this.response = response;
        this.parameters = parameters;
        this.contextName = request.getContextPath().substring(1);
        this.router = router;
        this.renderContext = new RenderContext();
    }

    public WebAppController getController() {
        return this.controller;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public String getParameter(QualifiedName parameter) {
        return this.parameters.get(parameter);
    }

    public void renderURL(Map<QualifiedName, String> parameters, URIWriter uriWriter) throws IOException {
        this.renderContext.reset(parameters);
        uriWriter.append('/');
        uriWriter.appendSegment(this.contextName);
        this.router.render(this.renderContext, uriWriter);
    }
}

