/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.security.oauth.test;

import org.exoplatform.component.test.AbstractKernelTest;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.container.PortalContainer;
import org.gatein.security.oauth.facebook.FacebookAccessTokenContext;
import org.gatein.security.oauth.linkedin.LinkedInPrincipalProcessor;
import org.gatein.security.oauth.linkedin.LinkedinAccessTokenContext;
import org.gatein.security.oauth.spi.OAuthPrincipalProcessor;
import org.gatein.security.oauth.spi.OAuthProviderType;
import org.gatein.security.oauth.spi.OAuthProviderTypeRegistry;
import org.gatein.security.oauth.test.DefaultPrincipalProcessorOverrided;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.portal.component.identity-configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.portal.component.web.oauth-configuration-overrided.xml")})
public class TestOAuthPrincipalProcessorOverrided
extends AbstractKernelTest {
    private OAuthProviderTypeRegistry oAuthProviderTypeRegistry;

    protected void setUp() throws Exception {
        PortalContainer portalContainer = PortalContainer.getInstance();
        this.oAuthProviderTypeRegistry = (OAuthProviderTypeRegistry)portalContainer.getComponentInstanceOfType(OAuthProviderTypeRegistry.class);
        this.begin();
    }

    protected void tearDown() throws Exception {
        this.end();
    }

    public void testOAuthPrincipalRegistration() {
        OAuthProviderType oAuthProvider = this.oAuthProviderTypeRegistry.getOAuthProvider("FACEBOOK", FacebookAccessTokenContext.class);
        OAuthPrincipalProcessor oauthPrincipalProcessor = oAuthProvider.getOauthPrincipalProcessor();
        TestOAuthPrincipalProcessorOverrided.assertNotNull((Object)oauthPrincipalProcessor);
        TestOAuthPrincipalProcessorOverrided.assertEquals(DefaultPrincipalProcessorOverrided.class, oauthPrincipalProcessor.getClass());
        oAuthProvider = this.oAuthProviderTypeRegistry.getOAuthProvider("LINKEDIN", LinkedinAccessTokenContext.class);
        oauthPrincipalProcessor = oAuthProvider.getOauthPrincipalProcessor();
        TestOAuthPrincipalProcessorOverrided.assertNotNull((Object)oauthPrincipalProcessor);
        TestOAuthPrincipalProcessorOverrided.assertEquals(LinkedInPrincipalProcessor.class, oauthPrincipalProcessor.getClass());
    }
}

