/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.security.oauth.test;

import com.google.api.client.googleapis.auth.oauth2.GoogleTokenResponse;
import java.lang.reflect.UndeclaredThrowableException;
import org.exoplatform.component.test.AbstractKernelTest;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.organization.impl.UserImpl;
import org.exoplatform.web.security.codec.AbstractCodec;
import org.exoplatform.web.security.codec.CodecInitializer;
import org.gatein.security.oauth.exception.OAuthException;
import org.gatein.security.oauth.exception.OAuthExceptionCode;
import org.gatein.security.oauth.facebook.FacebookAccessTokenContext;
import org.gatein.security.oauth.google.GoogleAccessTokenContext;
import org.gatein.security.oauth.spi.AccessTokenContext;
import org.gatein.security.oauth.spi.OAuthProviderType;
import org.gatein.security.oauth.spi.OAuthProviderTypeRegistry;
import org.gatein.security.oauth.spi.SocialNetworkService;
import org.gatein.security.oauth.twitter.TwitterAccessTokenContext;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.portal.component.identity-configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.portal.component.web.oauth-configuration.xml")})
public class TestSocialNetworkService
extends AbstractKernelTest {
    private OrganizationService orgService;
    private SocialNetworkService socialNetworkService;
    private OAuthProviderTypeRegistry oAuthProviderTypeRegistry;
    private AbstractCodec codec;

    protected void setUp() throws Exception {
        PortalContainer portalContainer = PortalContainer.getInstance();
        this.orgService = (OrganizationService)portalContainer.getComponentInstanceOfType(OrganizationService.class);
        this.socialNetworkService = (SocialNetworkService)portalContainer.getComponentInstanceOfType(SocialNetworkService.class);
        this.oAuthProviderTypeRegistry = (OAuthProviderTypeRegistry)portalContainer.getComponentInstanceOfType(OAuthProviderTypeRegistry.class);
        CodecInitializer codecInitializer = (CodecInitializer)portalContainer.getComponentInstanceOfType(CodecInitializer.class);
        this.codec = codecInitializer.getCodec();
        this.begin();
    }

    protected void tearDown() throws Exception {
        this.end();
    }

    public void testPersistOAuthProviderUsernames() throws Exception {
        UserImpl user1 = new UserImpl("testUser1");
        UserImpl user2 = new UserImpl("testUser2");
        this.orgService.getUserHandler().createUser((User)user1, false);
        this.orgService.getUserHandler().createUser((User)user2, false);
        UserProfile userProfile1 = this.orgService.getUserProfileHandler().createUserProfileInstance(user1.getUserName());
        userProfile1.setAttribute("user.social-info.facebook.userName", "joseph.doyle");
        userProfile1.setAttribute("user.social-info.google.userName", "joseph.something");
        this.orgService.getUserProfileHandler().saveUserProfile(userProfile1, true);
        UserProfile userProfile2 = this.orgService.getUserProfileHandler().createUserProfileInstance(user2.getUserName());
        userProfile2.setAttribute("user.social-info.facebook.userName", "john.doyle");
        userProfile2.setAttribute("user.social-info.google.userName", "john.something");
        this.orgService.getUserProfileHandler().saveUserProfile(userProfile2, true);
        User foundUser = this.socialNetworkService.findUserByOAuthProviderUsername(this.getFacebookProvider(), "joseph.doyle");
        TestSocialNetworkService.assertNotNull((Object)foundUser);
        TestSocialNetworkService.assertEquals((String)foundUser.getUserName(), (String)user1.getUserName());
        User foundUser2 = this.socialNetworkService.findUserByOAuthProviderUsername(this.getFacebookProvider(), "john.doyle");
        TestSocialNetworkService.assertNotNull((Object)foundUser2);
        TestSocialNetworkService.assertEquals((String)foundUser2.getUserName(), (String)user2.getUserName());
        User foundUser3 = this.socialNetworkService.findUserByOAuthProviderUsername(this.getGoogleProvider(), "john.something");
        TestSocialNetworkService.assertNotNull((Object)foundUser3);
        TestSocialNetworkService.assertEquals((String)foundUser3.getUserName(), (String)user2.getUserName());
        this.socialNetworkService.updateOAuthInfo(this.getFacebookProvider(), user1.getUserName(), "joseph.doyle.changed", (AccessTokenContext)this.createFacebookAccessToken("someToken", new String[0]));
        User foundUser4 = this.socialNetworkService.findUserByOAuthProviderUsername(this.getFacebookProvider(), "joseph.doyle.changed");
        TestSocialNetworkService.assertNotNull((Object)foundUser4);
        TestSocialNetworkService.assertEquals((String)foundUser4.getUserName(), (String)user1.getUserName());
        try {
            this.socialNetworkService.updateOAuthInfo(this.getFacebookProvider(), user2.getUserName(), "joseph.doyle.changed", (AccessTokenContext)this.createFacebookAccessToken("someToken", new String[0]));
            TestSocialNetworkService.fail((String)"Exception should occur because of duplicated facebook username");
        }
        catch (OAuthException gtnOauthOAuthException) {
            TestSocialNetworkService.assertEquals((Object)OAuthExceptionCode.DUPLICATE_OAUTH_PROVIDER_USERNAME, (Object)gtnOauthOAuthException.getExceptionCode());
            TestSocialNetworkService.assertEquals((Object)"user.social-info.facebook.userName", (Object)gtnOauthOAuthException.getExceptionAttribute("OAuthProviderUsernameAttributeName"));
            TestSocialNetworkService.assertEquals((Object)"joseph.doyle.changed", (Object)gtnOauthOAuthException.getExceptionAttribute("OAuthProviderUsername"));
        }
        catch (Exception e) {
            throw new UndeclaredThrowableException(e);
        }
        this.orgService.getUserHandler().removeUser(user1.getUserName(), false);
        this.orgService.getUserHandler().removeUser(user2.getUserName(), false);
    }

    public void testPersistOAuthAccessTokens() throws Exception {
        UserImpl user1 = new UserImpl("testUser1");
        UserImpl user2 = new UserImpl("testUser2");
        this.orgService.getUserHandler().createUser((User)user1, false);
        this.orgService.getUserHandler().createUser((User)user2, false);
        this.socialNetworkService.updateOAuthAccessToken(this.getFacebookProvider(), user1.getUserName(), (AccessTokenContext)this.createFacebookAccessToken("aaa123", new String[0]));
        this.socialNetworkService.updateOAuthAccessToken(this.getFacebookProvider(), user2.getUserName(), (AccessTokenContext)this.createFacebookAccessToken("bbb456", new String[0]));
        GoogleAccessTokenContext googleToken = this.createGoogleAccessToken("ccc789", "rfrc487", "http://someScope");
        this.socialNetworkService.updateOAuthAccessToken(this.getGoogleProvider(), user1.getUserName(), (AccessTokenContext)googleToken);
        TwitterAccessTokenContext twitterToken = new TwitterAccessTokenContext("tok1", "secret1");
        this.socialNetworkService.updateOAuthAccessToken(this.getTwitterProvider(), user1.getUserName(), (AccessTokenContext)twitterToken);
        TestSocialNetworkService.assertEquals((String)"aaa123", (String)((FacebookAccessTokenContext)this.socialNetworkService.getOAuthAccessToken(this.getFacebookProvider(), user1.getUserName())).getAccessToken());
        TestSocialNetworkService.assertEquals((String)"bbb456", (String)((FacebookAccessTokenContext)this.socialNetworkService.getOAuthAccessToken(this.getFacebookProvider(), user2.getUserName())).getAccessToken());
        googleToken = this.createGoogleAccessToken("ccc789", "rfrc487", "http://someScope");
        TestSocialNetworkService.assertEquals((Object)googleToken, (Object)this.socialNetworkService.getOAuthAccessToken(this.getGoogleProvider(), user1.getUserName()));
        TestSocialNetworkService.assertNull((Object)this.socialNetworkService.getOAuthAccessToken(this.getGoogleProvider(), user2.getUserName()));
        TestSocialNetworkService.assertEquals((Object)new TwitterAccessTokenContext("tok1", "secret1"), (Object)this.socialNetworkService.getOAuthAccessToken(this.getTwitterProvider(), user1.getUserName()));
        TestSocialNetworkService.assertNull((Object)this.socialNetworkService.getOAuthAccessToken(this.getTwitterProvider(), user2.getUserName()));
        UserProfile userProfile1 = this.orgService.getUserProfileHandler().findUserProfileByName("testUser1");
        UserProfile userProfile2 = this.orgService.getUserProfileHandler().findUserProfileByName("testUser2");
        String encodedAccessToken1 = userProfile1.getAttribute("user.social-info.facebook.accessToken.1");
        String encodedAccessToken2 = userProfile2.getAttribute("user.social-info.facebook.accessToken.1");
        TestSocialNetworkService.assertFalse((boolean)"aaa123".equals(encodedAccessToken1));
        TestSocialNetworkService.assertFalse((boolean)"bbb456".equals(encodedAccessToken2));
        TestSocialNetworkService.assertTrue((boolean)this.codec.encode("aaa123").equals(encodedAccessToken1));
        TestSocialNetworkService.assertTrue((boolean)this.codec.encode("bbb456").equals(encodedAccessToken2));
        this.socialNetworkService.removeOAuthAccessToken(this.getFacebookProvider(), user1.getUserName());
        this.socialNetworkService.removeOAuthAccessToken(this.getGoogleProvider(), user1.getUserName());
        this.socialNetworkService.removeOAuthAccessToken(this.getTwitterProvider(), user1.getUserName());
        TestSocialNetworkService.assertNull((Object)this.socialNetworkService.getOAuthAccessToken(this.getFacebookProvider(), user1.getUserName()));
        TestSocialNetworkService.assertNull((Object)this.socialNetworkService.getOAuthAccessToken(this.getGoogleProvider(), user1.getUserName()));
        TestSocialNetworkService.assertNull((Object)this.socialNetworkService.getOAuthAccessToken(this.getTwitterProvider(), user1.getUserName()));
        TestSocialNetworkService.assertNotNull((Object)this.socialNetworkService.getOAuthAccessToken(this.getFacebookProvider(), user2.getUserName()));
        this.orgService.getUserHandler().removeUser(user1.getUserName(), false);
        this.orgService.getUserHandler().removeUser(user2.getUserName(), false);
    }

    public void testInvalidationOfAccessTokens() throws Exception {
        UserImpl user1 = new UserImpl("testUser1");
        this.orgService.getUserHandler().createUser((User)user1, false);
        this.socialNetworkService.updateOAuthInfo(this.getFacebookProvider(), user1.getUserName(), "fbUsername1", (AccessTokenContext)this.createFacebookAccessToken("fbAccessToken1", new String[0]));
        TestSocialNetworkService.assertEquals((String)"fbAccessToken1", (String)((FacebookAccessTokenContext)this.socialNetworkService.getOAuthAccessToken(this.getFacebookProvider(), user1.getUserName())).getAccessToken());
        this.socialNetworkService.updateOAuthInfo(this.getFacebookProvider(), user1.getUserName(), "fbUsername1", (AccessTokenContext)this.createFacebookAccessToken("fbAccessToken2", new String[0]));
        TestSocialNetworkService.assertEquals((String)"fbAccessToken2", (String)((FacebookAccessTokenContext)this.socialNetworkService.getOAuthAccessToken(this.getFacebookProvider(), user1.getUserName())).getAccessToken());
        UserProfile userProfile1 = this.orgService.getUserProfileHandler().findUserProfileByName(user1.getUserName());
        userProfile1.setAttribute(this.getFacebookProvider().getUserNameAttrName(), "fbUsername2");
        this.orgService.getUserProfileHandler().saveUserProfile(userProfile1, true);
        TestSocialNetworkService.assertNull((Object)this.socialNetworkService.getOAuthAccessToken(this.getFacebookProvider(), user1.getUserName()));
        this.socialNetworkService.updateOAuthAccessToken(this.getFacebookProvider(), user1.getUserName(), (AccessTokenContext)this.createFacebookAccessToken("fbAccessToken3", new String[0]));
        TestSocialNetworkService.assertEquals((String)"fbAccessToken3", (String)((FacebookAccessTokenContext)this.socialNetworkService.getOAuthAccessToken(this.getFacebookProvider(), user1.getUserName())).getAccessToken());
        userProfile1 = this.orgService.getUserProfileHandler().findUserProfileByName(user1.getUserName());
        userProfile1.setAttribute(this.getFacebookProvider().getUserNameAttrName(), null);
        this.orgService.getUserProfileHandler().saveUserProfile(userProfile1, true);
        TestSocialNetworkService.assertNull((Object)this.socialNetworkService.getOAuthAccessToken(this.getFacebookProvider(), user1.getUserName()));
        TwitterAccessTokenContext twitterToken = new TwitterAccessTokenContext("token1", "secret1");
        this.socialNetworkService.updateOAuthInfo(this.getTwitterProvider(), user1.getUserName(), "twitterUsername1", (AccessTokenContext)twitterToken);
        userProfile1 = this.orgService.getUserProfileHandler().findUserProfileByName(user1.getUserName());
        userProfile1.setAttribute(this.getTwitterProvider().getUserNameAttrName(), "twitterUsername2");
        this.orgService.getUserProfileHandler().saveUserProfile(userProfile1, true);
        TestSocialNetworkService.assertNull((Object)this.socialNetworkService.getOAuthAccessToken(this.getTwitterProvider(), user1.getUserName()));
        GoogleAccessTokenContext grc = this.createGoogleAccessToken("token1", "rf1", "http://someScope");
        this.socialNetworkService.updateOAuthInfo(this.getGoogleProvider(), user1.getUserName(), "googleUsername1", (AccessTokenContext)grc);
        userProfile1 = this.orgService.getUserProfileHandler().findUserProfileByName(user1.getUserName());
        userProfile1.setAttribute(this.getGoogleProvider().getUserNameAttrName(), "googleUsername2");
        this.orgService.getUserProfileHandler().saveUserProfile(userProfile1, true);
        TestSocialNetworkService.assertNull((Object)this.socialNetworkService.getOAuthAccessToken(this.getGoogleProvider(), user1.getUserName()));
        this.orgService.getUserHandler().removeUser(user1.getUserName(), false);
    }

    public void testLongAccessToken() throws Exception {
        UserImpl user1 = new UserImpl("testUser1");
        this.orgService.getUserHandler().createUser((User)user1, false);
        String longAccessToken = this.createLongString();
        this.socialNetworkService.updateOAuthInfo(this.getFacebookProvider(), user1.getUserName(), "fbUsername1", (AccessTokenContext)this.createFacebookAccessToken(longAccessToken, new String[0]));
        TestSocialNetworkService.assertEquals((String)longAccessToken, (String)((FacebookAccessTokenContext)this.socialNetworkService.getOAuthAccessToken(this.getFacebookProvider(), user1.getUserName())).getAccessToken());
        String shortAccessToken = "someToken1";
        this.socialNetworkService.updateOAuthInfo(this.getFacebookProvider(), user1.getUserName(), "fbUsername1", (AccessTokenContext)this.createFacebookAccessToken(shortAccessToken, new String[0]));
        TestSocialNetworkService.assertEquals((String)shortAccessToken, (String)((FacebookAccessTokenContext)this.socialNetworkService.getOAuthAccessToken(this.getFacebookProvider(), user1.getUserName())).getAccessToken());
        GoogleAccessTokenContext grc = this.createGoogleAccessToken(longAccessToken, longAccessToken, "http://someScope");
        this.socialNetworkService.updateOAuthInfo(this.getGoogleProvider(), user1.getUserName(), "googleUsername1", (AccessTokenContext)grc);
        TestSocialNetworkService.assertEquals((Object)grc, (Object)this.socialNetworkService.getOAuthAccessToken(this.getGoogleProvider(), user1.getUserName()));
        this.socialNetworkService.removeOAuthAccessToken(this.getGoogleProvider(), user1.getUserName());
        TestSocialNetworkService.assertNull((Object)this.socialNetworkService.getOAuthAccessToken(this.getGoogleProvider(), user1.getUserName()));
        TwitterAccessTokenContext twitterToken = new TwitterAccessTokenContext(longAccessToken, longAccessToken);
        this.socialNetworkService.updateOAuthAccessToken(this.getTwitterProvider(), user1.getUserName(), (AccessTokenContext)twitterToken);
        TestSocialNetworkService.assertEquals((Object)twitterToken, (Object)this.socialNetworkService.getOAuthAccessToken(this.getTwitterProvider(), user1.getUserName()));
        twitterToken = new TwitterAccessTokenContext(shortAccessToken, shortAccessToken);
        this.socialNetworkService.updateOAuthAccessToken(this.getTwitterProvider(), user1.getUserName(), (AccessTokenContext)twitterToken);
        TestSocialNetworkService.assertEquals((Object)twitterToken, (Object)this.socialNetworkService.getOAuthAccessToken(this.getTwitterProvider(), user1.getUserName()));
        this.orgService.getUserHandler().removeUser(user1.getUserName(), false);
    }

    public void testAccessTokensWithMoreScopes() throws Exception {
        UserImpl user1 = new UserImpl("testUser1");
        this.orgService.getUserHandler().createUser((User)user1, false);
        GoogleAccessTokenContext googleToken = this.createGoogleAccessToken("ccc789", "rfrc487", "http://someScope", "http://someScope2");
        this.socialNetworkService.updateOAuthAccessToken(this.getGoogleProvider(), user1.getUserName(), (AccessTokenContext)googleToken);
        TestSocialNetworkService.assertEquals((Object)googleToken, (Object)this.socialNetworkService.getOAuthAccessToken(this.getGoogleProvider(), user1.getUserName()));
        FacebookAccessTokenContext facebookToken = this.createFacebookAccessToken("ddd789", "rfrc4876", "email", "publish_stream");
        this.socialNetworkService.updateOAuthAccessToken(this.getFacebookProvider(), user1.getUserName(), (AccessTokenContext)facebookToken);
        TestSocialNetworkService.assertEquals((Object)facebookToken, (Object)this.socialNetworkService.getOAuthAccessToken(this.getFacebookProvider(), user1.getUserName()));
        this.orgService.getUserHandler().removeUser(user1.getUserName(), false);
    }

    private OAuthProviderType<FacebookAccessTokenContext> getFacebookProvider() {
        return this.oAuthProviderTypeRegistry.getOAuthProvider("FACEBOOK", FacebookAccessTokenContext.class);
    }

    private OAuthProviderType<GoogleAccessTokenContext> getGoogleProvider() {
        return this.oAuthProviderTypeRegistry.getOAuthProvider("GOOGLE", GoogleAccessTokenContext.class);
    }

    private OAuthProviderType<TwitterAccessTokenContext> getTwitterProvider() {
        return this.oAuthProviderTypeRegistry.getOAuthProvider("TWITTER", TwitterAccessTokenContext.class);
    }

    private GoogleAccessTokenContext createGoogleAccessToken(String accessToken, String refreshToken, String ... scope) {
        GoogleTokenResponse grc = new GoogleTokenResponse();
        grc.setAccessToken(accessToken);
        grc.setRefreshToken(refreshToken);
        grc.setExpiresInSeconds(Long.valueOf(1000L));
        grc.setTokenType("Bearer");
        grc.setIdToken("someTokenId");
        return new GoogleAccessTokenContext(grc, scope);
    }

    private FacebookAccessTokenContext createFacebookAccessToken(String accessToken, String ... scope) {
        if (scope == null) {
            scope = new String[]{"email"};
        }
        return new FacebookAccessTokenContext(accessToken, scope);
    }

    private String createLongString() {
        StringBuilder builder = new StringBuilder("1324567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890");
        for (int i = 0; i < 3; ++i) {
            builder.append((CharSequence)builder);
        }
        return builder.toString();
    }
}

