/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.resource;

import java.util.List;
import java.util.Set;
import org.exoplatform.portal.resource.SkinDependentManager;
import org.exoplatform.portal.resource.SkinKey;
import org.exoplatform.portal.resource.SkinService;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.wci.WebApp;
import org.gatein.wci.WebAppEvent;
import org.gatein.wci.WebAppLifeCycleEvent;
import org.gatein.wci.WebAppListener;

public class GateInSkinConfigRemoval
implements WebAppListener {
    private final Logger log = LoggerFactory.getLogger(GateInSkinConfigRemoval.class);
    private SkinService service;

    public GateInSkinConfigRemoval(SkinService _service) {
        this.service = _service;
    }

    public void onEvent(WebAppEvent event) {
        WebAppLifeCycleEvent waEvent;
        if (event instanceof WebAppLifeCycleEvent && (waEvent = (WebAppLifeCycleEvent)event).getType() == 0) {
            String webApp = event.getWebApp().getServletContext().getContextPath();
            this.removeWebAppSkin(webApp);
            this.removeContextAppSkin(event.getWebApp());
        }
    }

    private void removeWebAppSkin(String webApp) {
        try {
            this.removePortalSkins(webApp);
            this.removePortletSkins(webApp);
            this.removeSkinName(webApp);
            SkinDependentManager.clearAssociatedSkins(webApp);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void removeContextAppSkin(WebApp webApp) {
        this.service.unregisterServletContext(webApp);
    }

    private void removePortalSkins(String webApp) throws Exception {
        List<SkinKey> portalSkins = SkinDependentManager.getPortalSkins(webApp);
        this.service.remove(portalSkins);
    }

    private void removePortletSkins(String webApp) throws Exception {
        List<SkinKey> portletSkins = SkinDependentManager.getPortletSkins(webApp);
        this.service.remove(portletSkins);
    }

    private void removeSkinName(String webApp) throws Exception {
        Set<String> supportedSkins = SkinDependentManager.getSkinNames(webApp);
        if (supportedSkins != null) {
            for (String skin : supportedSkins) {
                if (!SkinDependentManager.skinNameIsRemovable(skin, webApp)) continue;
                this.service.removeSupportedSkin(skin);
            }
        }
    }
}

