/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.security.security;

import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.management.annotations.Impact;
import org.exoplatform.management.annotations.ImpactType;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.web.security.Token;
import org.exoplatform.web.security.TokenStore;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.wci.security.Credentials;
import org.picocontainer.Startable;

@Managed
@ManagedDescription(value="Token Store Service")
@NameTemplate(value={@Property(key="service", value="TokenStore"), @Property(key="name", value="{Name}")})
public abstract class AbstractTokenService<T extends Token, K>
implements Startable,
TokenStore {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected static final String SERVICE_CONFIG = "service.configuration";
    protected static final int DELAY_TIME = 600;
    protected final Random random = new Random();
    protected String name;
    protected long validityMillis;
    private ScheduledExecutorService executor;

    public AbstractTokenService(InitParams initParams) {
        ArrayList params = initParams.getValuesParam(SERVICE_CONFIG).getValues();
        this.name = (String)params.get(0);
        long configValue = new Long((String)params.get(1));
        this.validityMillis = TimeoutEnum.valueOf((String)params.get(2)).toMilisecond(configValue);
    }

    public void start() {
        final AbstractTokenService service = this;
        this.executor = Executors.newSingleThreadScheduledExecutor();
        this.executor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                try {
                    service.cleanExpiredTokens();
                }
                catch (Throwable t) {
                    AbstractTokenService.this.log.warn((Object)"Failed to clean expired tokens", t);
                }
            }
        }, 0L, 600L, TimeUnit.SECONDS);
    }

    public void stop() {
        this.executor.shutdown();
    }

    public static <T extends AbstractTokenService> T getInstance(Class<T> classType) {
        PortalContainer container = PortalContainer.getInstance();
        return (T)((AbstractTokenService)classType.cast(container.getComponentInstanceOfType(classType)));
    }

    @Override
    public Credentials validateToken(String stringKey, boolean remove) {
        if (stringKey == null) {
            throw new NullPointerException();
        }
        K tokenKey = this.decodeKey(stringKey);
        try {
            T token = remove ? this.deleteToken(tokenKey) : this.getToken(tokenKey);
            if (token != null) {
                boolean valid;
                boolean bl = valid = token.getExpirationTimeMillis() > System.currentTimeMillis();
                if (valid) {
                    return token.getPayload();
                }
                if (!remove) {
                    this.deleteToken(tokenKey);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return null;
    }

    @Managed
    @ManagedDescription(value="Clean all tokens are expired")
    @Impact(value=ImpactType.IDEMPOTENT_WRITE)
    public void cleanExpiredTokens() {
        K[] ids;
        for (K id : ids = this.getAllTokens()) {
            T token = this.getToken(id);
            if (token == null || !token.isExpired()) continue;
            this.deleteToken(id);
        }
    }

    @Managed
    @ManagedDescription(value="Get time for token expiration in seconds")
    public long getValidityTime() {
        return this.validityMillis / 1000L;
    }

    @Managed
    @ManagedDescription(value="The expiration daemon period time in seconds")
    public long getPeriodTime() {
        return 600L;
    }

    @Managed
    @ManagedDescription(value="The token service name")
    public String getName() {
        return this.name;
    }

    public abstract T getToken(K var1);

    public abstract T deleteToken(K var1);

    public abstract K[] getAllTokens();

    protected abstract K decodeKey(String var1);

    @Managed
    @ManagedDescription(value="The number of tokens")
    @Impact(value=ImpactType.READ)
    public abstract long size();

    protected String nextTokenId() {
        return "rememberme" + this.random.nextInt();
    }

    private static enum TimeoutEnum {
        SECOND(1000L),
        MINUTE(60000L),
        HOUR(3600000L),
        DAY(86400000L);

        private long multiply;

        private TimeoutEnum(long multiply) {
            this.multiply = multiply;
        }

        public long toMilisecond(long configValue) {
            return configValue * this.multiply;
        }
    }
}

