/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.security;

import org.exoplatform.component.test.AbstractKernelTest;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.web.security.SimpleGeneratorCookieTokenService;
import org.gatein.wci.security.Credentials;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/tokenservice-configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.portal.component.test.jcr-configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/jcr-configuration.xml")})
public class TestSimpleGeneratorService
extends AbstractKernelTest {
    private SimpleGeneratorCookieTokenService service;

    protected void setUp() throws Exception {
        PortalContainer container = this.getContainer();
        this.service = (SimpleGeneratorCookieTokenService)((Object)container.getComponentInstanceOfType(SimpleGeneratorCookieTokenService.class));
        Thread.sleep(1000L);
    }

    public void testDuplicatedTokenGeneration() throws Exception {
        String token1 = this.service.createToken(new Credentials("root1", "gtn1"));
        TestSimpleGeneratorService.assertEquals((String)token1, (String)"rememberme0");
        TestSimpleGeneratorService.assertEquals((int)this.service.getCounter(), (int)1);
        String token2 = this.service.createToken(new Credentials("root2", "gtn2"));
        TestSimpleGeneratorService.assertEquals((String)token2, (String)"rememberme1");
        TestSimpleGeneratorService.assertEquals((int)this.service.getCounter(), (int)2);
        String token3 = this.service.createToken(new Credentials("root3", "gtn3"));
        TestSimpleGeneratorService.assertEquals((String)token3, (String)"rememberme2");
        TestSimpleGeneratorService.assertEquals((int)this.service.getCounter(), (int)4);
        TestSimpleGeneratorService.assertEquals((String)this.service.getToken(token1).getPayload().getUsername(), (String)"root1");
        TestSimpleGeneratorService.assertEquals((String)this.service.getToken(token2).getPayload().getUsername(), (String)"root2");
        TestSimpleGeneratorService.assertEquals((String)this.service.getToken(token3).getPayload().getUsername(), (String)"root3");
    }
}

