/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.security.hash;

import java.util.StringTokenizer;
import org.exoplatform.web.security.hash.SaltedHash;
import org.exoplatform.web.security.hash.SaltedHashCodec;
import org.exoplatform.web.security.hash.SaltedHashEncodingException;
import org.gatein.common.util.Base64;

public class XmlSafeSaltedHashCodec
implements SaltedHashCodec {
    public static final SaltedHashCodec INSTANCE = new XmlSafeSaltedHashCodec();
    private final char delimiter = (char)46;

    @Override
    public String encode(SaltedHash saltedHash) {
        if (saltedHash == null) {
            return null;
        }
        String salt = this.toString(saltedHash.getSalt());
        String hash = this.toString(saltedHash.getHash());
        String algorithm = saltedHash.getAlgorithm();
        int iterationCount = saltedHash.getIterationCount();
        StringBuilder buffer = new StringBuilder(algorithm.length() + 8 + salt.length() + hash.length() + 3);
        return buffer.append(algorithm).append('.').append(iterationCount).append('.').append(salt).append('.').append(hash).toString();
    }

    @Override
    public SaltedHash decode(String encodedSaltedHash) throws SaltedHashEncodingException {
        StringTokenizer st = new StringTokenizer(encodedSaltedHash, String.valueOf('.'));
        if (st.hasMoreTokens()) {
            String algorithm = st.nextToken();
            try {
                if (st.hasMoreTokens()) {
                    int iterationCount = Integer.parseInt(st.nextToken());
                    if (st.hasMoreTokens()) {
                        String saltString = st.nextToken();
                        byte[] saltBytes = this.toBytes(saltString);
                        if (st.hasMoreTokens()) {
                            String hashString = st.nextToken();
                            byte[] hashBytes = this.toBytes(hashString);
                            return new SaltedHash(algorithm, iterationCount, saltBytes, hashBytes);
                        }
                    }
                }
            }
            catch (NumberFormatException e) {
                throw new SaltedHashEncodingException("Could not decode salted hash '" + encodedSaltedHash + "'.", e);
            }
        }
        throw new SaltedHashEncodingException("Encoded salted hash '" + encodedSaltedHash + "' too short.");
    }

    protected String toString(byte[] bytes) {
        return Base64.encodeBytes((byte[])bytes, (Base64.EncodingOption)Base64.EncodingOption.USEURLSAFEENCODING);
    }

    protected byte[] toBytes(String str) {
        return Base64.decode((String)str, (Base64.EncodingOption)Base64.EncodingOption.USEURLSAFEENCODING);
    }
}

