/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.management.gadget.mop.exportimport.server;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.management.gadget.mop.exportimport.server.ContainerCallback;
import org.gatein.management.gadget.mop.exportimport.server.ContainerRequestHandler;

public class FileDownloadServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(FileDownloadServlet.class);
    private static final SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String portalContainerName = request.getParameter("pc");
        String type = request.getParameter("ownerType");
        String name = request.getParameter("ownerId");
        String safeName = name.replaceAll("/", "-");
        if (safeName.startsWith("-")) {
            safeName = safeName.substring(1);
        }
        String filename = type + "_" + safeName + "_" + this.getTimestamp() + ".zip";
        response.setContentType("application/octet-stream; charset=UTF-8");
        response.setHeader("Content-disposition", "attachment; filename=\"" + filename + "\"");
        ServletOutputStream os = response.getOutputStream();
        try {
            ContainerRequestHandler.doInRequest((String)portalContainerName, (ContainerCallback)new /* Unavailable Anonymous Inner Class!! */);
            os.flush();
        }
        catch (Exception e) {
            log.error((Object)"Error during download", (Throwable)e);
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    private String getTimestamp() {
        return SDF.format(new Date());
    }
}

