/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.management.gadget.mop.exportimport.server;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.web.AbstractFilter;
import org.exoplatform.services.security.ConversationRegistry;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.StateKey;
import org.exoplatform.services.security.web.HttpSessionStateKey;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

public class IdentityFilter
extends AbstractFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(IdentityFilter.class);
    private String role;
    private String group;
    private String user;

    protected void afterInit(FilterConfig config) throws ServletException {
        this.role = config.getInitParameter("role");
        this.group = config.getInitParameter("group");
        this.user = config.getInitParameter("user");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        HttpSession httpSession = httpRequest.getSession();
        HttpSessionStateKey stateKey = new HttpSessionStateKey(httpSession);
        ExoContainer container = this.getContainer();
        ConversationRegistry conversationRegistry = (ConversationRegistry)container.getComponentInstanceOfType(ConversationRegistry.class);
        ConversationState state = conversationRegistry.getState((StateKey)stateKey);
        if (state == null) {
            log.error((Object)"Conversation state not found. This typically means the GWT Gadget application is either being access anonymously or from outside the portal.");
            this.handleError(httpRequest, httpResponse, 401);
            return;
        }
        Identity identity = state.getIdentity();
        if (identity == null) {
            log.error((Object)"Identity not found from conversation state. This should not happen. GWT Gadget will not process");
            this.handleError(httpRequest, httpResponse, 401);
            return;
        }
        ConversationState.setCurrent((ConversationState)state);
        if (this.role == null && this.group == null && this.user == null) {
            log.error((Object)"Neither role, group, or user was configured as part of init-param of IdentityFilter for GWT Gadget application.");
            this.handleError(httpRequest, httpResponse, 500);
            return;
        }
        if (this.role != null) {
            for (String identityRole : identity.getRoles()) {
                if (!this.role.equals(identityRole)) continue;
                chain.doFilter(request, response);
                return;
            }
        }
        if (this.group != null && identity.isMemberOf(this.group)) {
            chain.doFilter(request, response);
            return;
        }
        if (this.user != null && this.user.equals(identity.getUserId())) {
            chain.doFilter(request, response);
            return;
        }
        log.error((Object)("GWT Gadget not authorized for user " + identity.getUserId() + ". Check the filter configuration for IdentityFilter in web.xml."));
        this.handleError(httpRequest, httpResponse, 401);
    }

    public void destroy() {
    }

    private void handleError(HttpServletRequest request, HttpServletResponse response, int code) throws IOException {
        if (request.getServletPath().equals("/exportimport/upload")) {
            response.setContentType("text/plain");
            PrintWriter writer = response.getWriter();
            ((Writer)writer).write("<response><error>Resource not available</error></response>");
            ((Writer)writer).flush();
            ((Writer)writer).close();
        } else {
            response.sendError(code);
        }
    }
}

