/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.runtime;

import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.jsp.JspApplicationContext;
import javax.servlet.jsp.JspEngineInfo;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.PageContext;
import org.apache.jasper.Constants;
import org.apache.jasper.runtime.JspApplicationContextImpl;
import org.apache.jasper.runtime.PageContextImpl;
import org.jboss.logging.Logger;

public class JspFactoryImpl
extends JspFactory {
    private Logger log = Logger.getLogger(JspFactoryImpl.class);
    private static final String SPEC_VERSION = "2.2";
    private static final boolean USE_POOL = Boolean.valueOf(System.getProperty("org.apache.jasper.runtime.JspFactoryImpl.USE_POOL", "true"));
    private static final int POOL_SIZE = Integer.valueOf(System.getProperty("org.apache.jasper.runtime.JspFactoryImpl.POOL_SIZE", "8"));
    private ThreadLocal<PageContextPool> localPool = new ThreadLocal();

    public PageContext getPageContext(Servlet servlet, ServletRequest request, ServletResponse response, String errorPageURL, boolean needsSession, int bufferSize, boolean autoflush) {
        if (Constants.IS_SECURITY_ENABLED) {
            PrivilegedGetPageContext dp = new PrivilegedGetPageContext(this, servlet, request, response, errorPageURL, needsSession, bufferSize, autoflush);
            return (PageContext)AccessController.doPrivileged(dp);
        }
        return this.internalGetPageContext(servlet, request, response, errorPageURL, needsSession, bufferSize, autoflush);
    }

    public void releasePageContext(PageContext pc) {
        if (pc == null) {
            return;
        }
        if (Constants.IS_SECURITY_ENABLED) {
            PrivilegedReleasePageContext dp = new PrivilegedReleasePageContext(this, pc);
            AccessController.doPrivileged(dp);
        } else {
            this.internalReleasePageContext(pc);
        }
    }

    public JspEngineInfo getEngineInfo() {
        return new JspEngineInfo(){

            public String getSpecificationVersion() {
                return JspFactoryImpl.SPEC_VERSION;
            }
        };
    }

    private PageContext internalGetPageContext(Servlet servlet, ServletRequest request, ServletResponse response, String errorPageURL, boolean needsSession, int bufferSize, boolean autoflush) {
        try {
            PageContextImpl pc;
            if (USE_POOL) {
                PageContextPool pool = this.localPool.get();
                if (pool == null) {
                    pool = new PageContextPool();
                    this.localPool.set(pool);
                }
                if ((pc = pool.get()) == null) {
                    pc = new PageContextImpl();
                }
            } else {
                pc = new PageContextImpl();
            }
            pc.initialize(servlet, request, response, errorPageURL, needsSession, bufferSize, autoflush);
            return pc;
        }
        catch (Throwable ex) {
            this.log.fatal((Object)"Exception initializing page context", ex);
            return null;
        }
    }

    private void internalReleasePageContext(PageContext pc) {
        pc.release();
        if (USE_POOL && pc instanceof PageContextImpl) {
            this.localPool.get().put(pc);
        }
    }

    public JspApplicationContext getJspApplicationContext(ServletContext context) {
        return JspApplicationContextImpl.getInstance(context);
    }

    protected static final class PageContextPool {
        private PageContext[] pool = new PageContext[JspFactoryImpl.access$200()];
        private int current = -1;

        public void put(PageContext o) {
            if (this.current < POOL_SIZE - 1) {
                ++this.current;
                this.pool[this.current] = o;
            }
        }

        public PageContext get() {
            PageContext item = null;
            if (this.current >= 0) {
                item = this.pool[this.current];
                --this.current;
            }
            return item;
        }
    }

    private class PrivilegedReleasePageContext
    implements PrivilegedAction {
        private JspFactoryImpl factory;
        private PageContext pageContext;

        PrivilegedReleasePageContext(JspFactoryImpl factory, PageContext pageContext) {
            this.factory = factory;
            this.pageContext = pageContext;
        }

        public Object run() {
            this.factory.internalReleasePageContext(this.pageContext);
            return null;
        }
    }

    private class PrivilegedGetPageContext
    implements PrivilegedAction {
        private JspFactoryImpl factory;
        private Servlet servlet;
        private ServletRequest request;
        private ServletResponse response;
        private String errorPageURL;
        private boolean needsSession;
        private int bufferSize;
        private boolean autoflush;

        PrivilegedGetPageContext(JspFactoryImpl factory, Servlet servlet, ServletRequest request, ServletResponse response, String errorPageURL, boolean needsSession, int bufferSize, boolean autoflush) {
            this.factory = factory;
            this.servlet = servlet;
            this.request = request;
            this.response = response;
            this.errorPageURL = errorPageURL;
            this.needsSession = needsSession;
            this.bufferSize = bufferSize;
            this.autoflush = autoflush;
        }

        public Object run() {
            return this.factory.internalGetPageContext(this.servlet, this.request, this.response, this.errorPageURL, this.needsSession, this.bufferSize, this.autoflush);
        }
    }
}

