/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.resources;

import java.io.File;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import org.apache.naming.resources.BaseDirContext;
import org.apache.naming.resources.FileDirContext;
import org.apache.naming.resources.WARDirContext;

public class AliasDirContext
extends BaseDirContext {
    protected Map<String, DirContext> aliases = new ConcurrentHashMap<String, DirContext>();

    public AliasDirContext() {
    }

    public AliasDirContext(Hashtable env) {
        super(env);
    }

    public void addAlias(String path, BaseDirContext dirContext) {
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException(this.sm.getString("resources.invalidAliasPath", path));
        }
        this.aliases.put(path, dirContext);
    }

    public void removeAlias(String path) {
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException(this.sm.getString("resources.invalidAliasPath", path));
        }
        this.aliases.remove(path);
    }

    public String getAliases() {
        StringBuilder result = new StringBuilder();
        Iterator<Map.Entry<String, DirContext>> iter = this.aliases.entrySet().iterator();
        boolean first = true;
        while (iter.hasNext()) {
            if (first) {
                first = false;
            } else {
                result.append(',');
            }
            Map.Entry<String, DirContext> entry = iter.next();
            result.append(entry.getKey());
            result.append('=');
            if (!(entry.getValue() instanceof BaseDirContext)) continue;
            result.append(((BaseDirContext)entry.getValue()).getDocBase());
        }
        return result.toString();
    }

    public void setAliases(String theAliases) {
        String[] kvps;
        this.aliases.clear();
        if (theAliases == null || theAliases.length() == 0) {
            return;
        }
        for (String kvp : kvps = theAliases.split(",")) {
            BaseDirContext context;
            String[] kv = kvp.split("=");
            if (kv.length != 2 || kv[0].length() == 0 || kv[1].length() == 0) {
                throw new IllegalArgumentException(this.sm.getString("resources.invalidAliasMapping", kvp));
            }
            File aliasLoc = new File(kv[1]);
            if (!aliasLoc.exists()) {
                throw new IllegalArgumentException(this.sm.getString("resources.invalidAliasNotExist", kv[1]));
            }
            if (kv[1].endsWith(".war") && !aliasLoc.isDirectory()) {
                context = new WARDirContext();
            } else if (aliasLoc.isDirectory()) {
                context = new FileDirContext();
            } else {
                throw new IllegalArgumentException(this.sm.getString("resources.invalidAliasFile", kv[1]));
            }
            context.setDocBase(kv[1]);
            this.addAlias(kv[0], context);
        }
    }

    private AliasResult findAlias(String name) {
        int slash;
        AliasResult result = new AliasResult();
        String searchName = name;
        result.dirContext = this.aliases.get(searchName);
        while (result.dirContext == null && (slash = searchName.lastIndexOf(47)) >= 0) {
            searchName = searchName.substring(0, slash);
            result.dirContext = this.aliases.get(searchName);
        }
        if (result.dirContext != null) {
            result.aliasName = name.substring(searchName.length());
        }
        return result;
    }

    @Override
    public void release() {
        this.aliases.clear();
        super.release();
    }

    @Override
    public Object lookup(String name) throws NamingException {
        AliasResult result = this.findAlias(name);
        if (result.dirContext != null) {
            return result.dirContext.lookup(result.aliasName);
        }
        throw new NameNotFoundException(this.sm.getString("resources.notFound", name));
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    @Override
    public void unbind(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public NamingEnumeration list(String name) throws NamingException {
        AliasResult result = this.findAlias(name);
        if (result.dirContext != null) {
            return result.dirContext.list(result.aliasName);
        }
        throw new NameNotFoundException(this.sm.getString("resources.notFound", name));
    }

    @Override
    public NamingEnumeration list(Name name) throws NamingException {
        return this.list(name.toString());
    }

    @Override
    public NamingEnumeration listBindings(String name) throws NamingException {
        AliasResult result = this.findAlias(name);
        if (result.dirContext != null) {
            return result.dirContext.listBindings(result.aliasName);
        }
        throw new NameNotFoundException(this.sm.getString("resources.notFound", name));
    }

    @Override
    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        return this.lookup(name);
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return this.docBase;
    }

    @Override
    public Attributes getAttributes(String name, String[] attrIds) throws NamingException {
        AliasResult result = this.findAlias(name);
        if (result.dirContext != null) {
            return result.dirContext.getAttributes(result.aliasName, attrIds);
        }
        throw new NameNotFoundException(this.sm.getString("resources.notFound", name));
    }

    @Override
    public Attributes getAttributes(Name name, String[] attrIds) throws NamingException {
        return this.getAttributes(name.toString(), attrIds);
    }

    @Override
    public void modifyAttributes(String name, int mod_op, Attributes attrs) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void modifyAttributes(String name, ModificationItem[] mods) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void bind(String name, Object obj, Attributes attrs) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void rebind(String name, Object obj, Attributes attrs) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public DirContext createSubcontext(String name, Attributes attrs) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public DirContext getSchema(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public DirContext getSchemaClassDefinition(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public NamingEnumeration search(String name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public NamingEnumeration search(String name, Attributes matchingAttributes) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public NamingEnumeration search(String name, String filter, SearchControls cons) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public NamingEnumeration search(String name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        throw new OperationNotSupportedException();
    }

    private static class AliasResult {
        DirContext dirContext;
        String aliasName;

        private AliasResult() {
        }
    }
}

