/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.integration.jboss.as7;

import java.io.File;
import org.gatein.integration.jboss.as7.GateInConfiguration;
import org.gatein.integration.jboss.as7.GateInSubsystemDefinition;
import org.gatein.integration.jboss.as7.GateInSubsystemParser;
import org.gatein.integration.jboss.as7.PortletWarDependencyDefinition;
import org.gatein.integration.jboss.as7.portal.PortalResourceRegistrar;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.deployment.Services;
import org.jboss.logging.Logger;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.ServiceName;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public class GateInExtension
implements Extension {
    private static final Logger log = Logger.getLogger((String)"org.gatein");
    public static final String NAMESPACE = "urn:jboss:domain:gatein:1.0";
    public static final String SUBSYSTEM_NAME = "gatein";
    private static final String RESOURCE_NAME = GateInExtension.class.getPackage().getName() + ".LocalDescriptions";

    static ResourceDescriptionResolver getResourceDescriptionResolver(String keyPrefix) {
        return new StandardResourceDescriptionResolver(keyPrefix, RESOURCE_NAME, GateInExtension.class.getClassLoader(), true, false);
    }

    public GateInExtension() {
        String confDir = new File(System.getProperty("jboss.server.config.dir"), SUBSYSTEM_NAME).getAbsolutePath();
        if (!System.getProperties().containsKey("exo.conf.dir")) {
            log.info((Object)"Setting 'exo.conf.dir'");
            System.setProperty("exo.conf.dir", confDir);
        }
        if (!System.getProperties().containsKey("exo.conf.dir.name")) {
            log.info((Object)"Setting 'exo.conf.dir.name'");
            System.setProperty("exo.conf.dir.name", SUBSYSTEM_NAME);
        }
        if (!System.getProperties().containsKey("gatein.conf.dir")) {
            log.info((Object)"Setting 'gatein.conf.dir'");
            System.setProperty("gatein.conf.dir", confDir);
        }
    }

    public void initialize(ExtensionContext context) {
        log.debug((Object)"Activating GateIn Extension");
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME, 1, 0);
        GateInConfiguration config = new GateInConfiguration();
        ManagementResourceRegistration registration = subsystem.registerSubsystemModel((ResourceDefinition)new GateInSubsystemDefinition(config));
        registration.registerOperationHandler("describe", (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE, (DescriptionProvider)GenericSubsystemDescribeHandler.INSTANCE, false, OperationEntry.EntryType.PRIVATE);
        registration.registerSubModel((ResourceDefinition)new PortletWarDependencyDefinition(config));
        PortalResourceRegistrar.registerPortalResources(registration, context.isRuntimeOnlyRegistrationValid());
        subsystem.registerXMLElementWriter((XMLElementWriter)GateInSubsystemParser.getInstance());
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(NAMESPACE, (XMLElementReader)GateInSubsystemParser.getInstance());
    }

    public static String skipModuleLoaderPrefix(String name) {
        if (name.startsWith("deployment.")) {
            return name.substring("deployment.".length());
        }
        return name;
    }

    public static ServiceName deploymentUnitName(ModuleIdentifier moduleId, Phase phase) {
        return ServiceName.of((ServiceName)Services.deploymentUnitName((String)GateInExtension.skipModuleLoaderPrefix(moduleId.getName())), (String[])new String[]{phase.name()});
    }

    public static ServiceName deploymentUnitName(ModuleIdentifier moduleId, String ... postfix) {
        return ServiceName.of((ServiceName)Services.deploymentUnitName((String)GateInExtension.skipModuleLoaderPrefix(moduleId.getName())), (String[])postfix);
    }
}

