/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.integration.jboss.as7.portal;

import java.util.EnumSet;
import java.util.Locale;
import org.gatein.integration.jboss.as7.portal.PortalReadOperationHandler;
import org.gatein.integration.jboss.as7.portal.PortalResourceConstants;
import org.gatein.integration.jboss.as7.portal.PortalResourceDescriptions;
import org.gatein.integration.jboss.as7.portal.StatisticsMetricHandler;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.CommonProviders;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;

public class PortalResourceRegistrar {
    private PortalResourceRegistrar() {
    }

    public static void registerPortalResources(ManagementResourceRegistration subsystem, boolean isRuntimeOnlyRegistrationValid) {
        EnumSet<OperationEntry.Flag> runtimeOnly = EnumSet.of(OperationEntry.Flag.RUNTIME_ONLY);
        OperationStepHandler handler = subsystem.getOperationHandler(PathAddress.EMPTY_ADDRESS, "read-resource");
        subsystem.registerOperationHandler("read-resource", (OperationStepHandler)new PortalReadOperationHandler(handler), new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return PortalResourceDescriptions.getPortalReadResourceDescription(locale);
            }
        }, runtimeOnly);
        handler = subsystem.getOperationHandler(PathAddress.EMPTY_ADDRESS, "read-children-names");
        subsystem.registerOperationHandler("read-children-names", (OperationStepHandler)new PortalReadOperationHandler(handler), CommonProviders.READ_CHILDREN_NAMES_PROVIDER, runtimeOnly);
        handler = subsystem.getOperationHandler(PathAddress.EMPTY_ADDRESS, "read-children-resources");
        subsystem.registerOperationHandler("read-children-resources", (OperationStepHandler)new PortalReadOperationHandler(handler), CommonProviders.READ_CHILDREN_RESOURCES_PROVIDER, runtimeOnly);
        ManagementResourceRegistration portal = subsystem.registerSubModel(PortalResourceConstants.PORTAL_PATH, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return PortalResourceDescriptions.getPortalResourceDescription(locale);
            }
        });
        ManagementResourceRegistration site = portal.registerSubModel(PortalResourceConstants.SITE_PATH, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return PortalResourceDescriptions.getSiteResourceDescription(locale);
            }
        });
        if (isRuntimeOnlyRegistrationValid) {
            StatisticsMetricHandler.registerMetrics("site", site);
        }
        ManagementResourceRegistration application = portal.registerSubModel(PortalResourceConstants.APPLICATION_PATH, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return PortalResourceDescriptions.getApplicationResourceDescription(locale);
            }
        });
        if (isRuntimeOnlyRegistrationValid) {
            StatisticsMetricHandler.registerMetrics("application", application);
        }
    }
}

