/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.integration.jboss.as7.deployment;

import java.util.List;
import org.gatein.integration.jboss.as7.GateInConfiguration;
import org.gatein.integration.jboss.as7.deployment.GateInConfigurationKey;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.moduleservice.ServiceModuleLoader;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;

public class GateInDependenciesDeploymentProcessor
implements DeploymentUnitProcessor {
    final ModuleIdentifier gateInLibId = ModuleIdentifier.fromString((String)"org.gatein.lib");

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit du = phaseContext.getDeploymentUnit();
        if (GateInConfiguration.isGateInOrPortletArchive(du)) {
            List dependencies = du.getAttachmentList(Attachments.MANIFEST_DEPENDENCIES);
            if (!this.containsDependency(dependencies, this.gateInLibId)) {
                du.addToAttachmentList(Attachments.MANIFEST_DEPENDENCIES, (Object)new ModuleDependency(Module.getBootModuleLoader(), this.gateInLibId, false, false, true, false));
            }
            ModuleIdentifier moduleId = (ModuleIdentifier)du.getAttachment(Attachments.MODULE_IDENTIFIER);
            if (GateInConfiguration.isGateInArchive(du)) {
                GateInConfiguration config = (GateInConfiguration)du.getAttachment(GateInConfigurationKey.KEY);
                ServiceModuleLoader deploymentModuleLoader = (ServiceModuleLoader)du.getAttachment(Attachments.SERVICE_MODULE_LOADER);
                if (!moduleId.equals(config.getGateInEarModule()) && !this.containsDependency(dependencies, config.getGateInEarModule())) {
                    du.addToAttachmentList(Attachments.MANIFEST_DEPENDENCIES, (Object)new ModuleDependency((ModuleLoader)deploymentModuleLoader, config.getGateInEarModule(), false, false, false, false));
                }
                for (ModuleIdentifier id : config.getGateInExtModules()) {
                    if (moduleId.equals(id) || this.containsDependency(dependencies, id)) continue;
                    du.addToAttachmentList(Attachments.MANIFEST_DEPENDENCIES, (Object)new ModuleDependency((ModuleLoader)deploymentModuleLoader, id, false, false, false, false));
                }
            }
        }
    }

    private boolean containsDependency(List<ModuleDependency> dependencies, ModuleIdentifier moduleId) {
        boolean exists = false;
        for (ModuleDependency dep : dependencies) {
            if (!dep.getIdentifier().equals(moduleId)) continue;
            exists = true;
            break;
        }
        return exists;
    }

    public void undeploy(DeploymentUnit context) {
    }
}

