/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.integration.jboss.as7.deployment;

import org.gatein.integration.jboss.as7.GateInConfiguration;
import org.gatein.integration.jboss.as7.deployment.GateInConfigurationKey;
import org.gatein.integration.jboss.as7.deployment.PortletWarKey;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.vfs.VirtualFile;

public class PortletWarDeploymentInitializingProcessor
implements DeploymentUnitProcessor {
    private static final String PORTLET_XML = "WEB-INF/portlet.xml";
    private GateInConfiguration config;

    public PortletWarDeploymentInitializingProcessor(GateInConfiguration config) {
        this.config = config;
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit du = phaseContext.getDeploymentUnit();
        if (!DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)du)) {
            return;
        }
        ResourceRoot deploymentRoot = (ResourceRoot)du.getAttachment(Attachments.DEPLOYMENT_ROOT);
        VirtualFile portletXml = deploymentRoot.getRoot().getChild(PORTLET_XML);
        if (portletXml.exists()) {
            du.putAttachment(PortletWarKey.INSTANCE, (Object)Boolean.TRUE);
            du.putAttachment(GateInConfigurationKey.KEY, (Object)this.config);
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

