/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.integration.jboss.as7.deployment.wsrp;

import java.util.List;
import org.gatein.integration.jboss.as7.deployment.wsrp.GateInWSRPKey;
import org.gatein.integration.wsrp.plugins.AS7Plugins;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.ServicesAttachment;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;

public class WSRPPostModuleDeploymentProcessor
implements DeploymentUnitProcessor {
    public static final AS7Plugins plugins = new AS7Plugins();
    static final List<String> KNOWN_PLUGIN_INTERFACE_NAMES = plugins.getKnownPluginInterfaceNames();

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        ServicesAttachment services;
        DeploymentUnit du = phaseContext.getDeploymentUnit();
        if (GateInWSRPKey.isGateInWSRPArchive(du) && (services = (ServicesAttachment)du.getAttachment(Attachments.SERVICES)) != null) {
            Module module = (Module)du.getAttachment(Attachments.MODULE);
            ModuleClassLoader classLoader = module != null ? module.getClassLoader() : null;
            for (String interfaceName : KNOWN_PLUGIN_INTERFACE_NAMES) {
                List serviceImplementations = services.getServiceImplementations(interfaceName);
                plugins.addPluginImplementations(interfaceName, serviceImplementations);
                if (classLoader == null) continue;
                for (String implementation : serviceImplementations) {
                    plugins.registerClassloader(implementation, (ClassLoader)classLoader);
                }
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

