/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.integration.jboss.as7.portal.resources;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.application.ApplicationStatisticService;
import org.gatein.integration.jboss.as7.portal.PortalContext;
import org.gatein.integration.jboss.as7.portal.resources.AbstractPortalResource;
import org.gatein.integration.jboss.as7.portal.resources.ApplicationRuntimeResource;
import org.gatein.integration.jboss.as7.portal.resources.SiteRuntimeResource;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;

public class PortalRuntimeResource
extends AbstractPortalResource {
    private static final Set<String> childTypes;

    public PortalRuntimeResource(PathElement pathElement) {
        super(pathElement, pathElement.getValue());
    }

    @Override
    protected Set<String> getChildrenNames() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> getChildrenNames(String childType) {
        if (childType.equals("site")) {
            return this.portalContext.getSites();
        }
        if (childType.equals("application")) {
            try {
                return this.portalContext.execute(new PortalContext.Request<Set<String>>(){

                    @Override
                    public Set<String> within(PortalContainer container) throws Exception {
                        ApplicationStatisticService service = this.getComponent(ApplicationStatisticService.class, container);
                        if (service == null) {
                            return Collections.emptySet();
                        }
                        return new LinkedHashSet<String>(Arrays.asList(service.getApplicationList()));
                    }
                });
            }
            catch (Exception e) {
                this.getLogger().error((Object)"Exception retrieving list of applications for runtime portal resource.", (Throwable)e);
                return Collections.emptySet();
            }
        }
        return Collections.emptySet();
    }

    @Override
    public Set<Resource.ResourceEntry> getChildren(String childType) {
        if (!this.hasChildren(childType)) {
            return Collections.emptySet();
        }
        LinkedHashSet<Resource.ResourceEntry> result = new LinkedHashSet<Resource.ResourceEntry>();
        for (String name : this.getChildrenNames(childType)) {
            result.add(this.getChildEntry(childType, name));
        }
        return result;
    }

    @Override
    public Resource getChild(PathElement element) {
        if (this.hasChildren(element.getKey())) {
            return this.getChildEntry(element.getKey(), element.getValue());
        }
        return null;
    }

    @Override
    protected Resource.ResourceEntry getChildEntry(String name) {
        throw new UnsupportedOperationException();
    }

    private Resource.ResourceEntry getChildEntry(String childType, String name) {
        if (childType.equals("site")) {
            return new SiteRuntimeResource(PathElement.pathElement((String)"site", (String)name), this.portalContext.getPortalContainerName());
        }
        if (childType.equals("application")) {
            return new ApplicationRuntimeResource(PathElement.pathElement((String)"application", (String)name), this.portalContext.getPortalContainerName());
        }
        return null;
    }

    public Set<String> getChildTypes() {
        return childTypes;
    }

    static {
        LinkedHashSet<String> set = new LinkedHashSet<String>(2);
        set.add("site");
        set.add("application");
        childTypes = set;
    }
}

