/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.integration.jboss.as7.portal;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.application.ApplicationStatisticService;
import org.exoplatform.portal.application.PortalStatisticService;
import org.gatein.integration.jboss.as7.portal.PortalContext;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class StatisticsMetricHandler
extends AbstractRuntimeOnlyHandler {
    private static final StatisticsMetricHandler INSTANCE = new StatisticsMetricHandler();

    static void registerMetrics(String type, ManagementResourceRegistration registration) {
        for (StatisticsMetric metric : StatisticsMetric.forType(type)) {
            registration.registerMetric(metric.definition, (OperationStepHandler)INSTANCE);
        }
    }

    private StatisticsMetricHandler() {
    }

    protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String portal = address.getElement(address.size() - 2).getValue();
        String type = address.getLastElement().getKey();
        String name = address.getLastElement().getValue();
        String attributeName = operation.require("name").asString();
        StatisticsMetric metric = StatisticsMetric.forName(attributeName);
        if (metric == null) {
            context.getFailureDescription().set(StatisticsMetricHandler.format("Unknown metric %s", attributeName));
        } else {
            try {
                ModelNode result = new ModelNode();
                switch (metric) {
                    case MAX_TIME: {
                        result.set(StatisticsMetricHandler.maxTime(portal, type, name));
                        break;
                    }
                    case MIN_TIME: {
                        result.set(StatisticsMetricHandler.minTime(portal, type, name));
                        break;
                    }
                    case AVERAGE_TIME: {
                        result.set(StatisticsMetricHandler.averageTime(portal, type, name));
                        break;
                    }
                    case THROUGHPUT: {
                        result.set(StatisticsMetricHandler.throughput(portal, type, name));
                        break;
                    }
                    case EXECUTION_COUNT: {
                        result.set(StatisticsMetricHandler.executionCount(portal, type, name));
                    }
                }
                context.getResult().set(result);
            }
            catch (OperationFailedException ofe) {
                throw ofe;
            }
            catch (Exception e) {
                throw new OperationFailedException(StatisticsMetricHandler.format("Unknown exception occurred while trying to obtain statistic metric %s for %s %s", new Object[]{metric, type, name}));
            }
        }
        context.completeStep();
    }

    private static double maxTime(String portal, String type, final String name) throws Exception {
        PortalContext context = new PortalContext(portal);
        if (type.equals("site")) {
            return context.execute(new PortalContext.Request<Double>(){

                @Override
                public Double within(PortalContainer container) {
                    return StatisticsMetricHandler.siteStatistic(container).getMaxTime(name);
                }
            });
        }
        if (type.equals("application")) {
            return context.execute(new PortalContext.Request<Double>(){

                @Override
                public Double within(PortalContainer container) {
                    return StatisticsMetricHandler.applicationStatistic(container).getMaxTime(name);
                }
            });
        }
        throw new OperationFailedException(StatisticsMetricHandler.format("Unknown service statistic type '%s'. Valid values are '%s' and '%s'.", type, "site", "application"));
    }

    private static double minTime(String portal, String type, final String name) throws Exception {
        PortalContext context = new PortalContext(portal);
        if (type.equals("site")) {
            return context.execute(new PortalContext.Request<Double>(){

                @Override
                public Double within(PortalContainer container) {
                    return StatisticsMetricHandler.siteStatistic(container).getMinTime(name);
                }
            });
        }
        if (type.equals("application")) {
            return context.execute(new PortalContext.Request<Double>(){

                @Override
                public Double within(PortalContainer container) {
                    return StatisticsMetricHandler.applicationStatistic(container).getMinTime(name);
                }
            });
        }
        throw new OperationFailedException(StatisticsMetricHandler.format("Unknown service statistic type '%s'. Valid values are '%s' and '%s'.", type, "site", "application"));
    }

    private static double averageTime(String portal, String type, final String name) throws Exception {
        PortalContext context = new PortalContext(portal);
        if (type.equals("site")) {
            return context.execute(new PortalContext.Request<Double>(){

                @Override
                public Double within(PortalContainer container) {
                    return StatisticsMetricHandler.siteStatistic(container).getAverageTime(name);
                }
            });
        }
        if (type.equals("application")) {
            return context.execute(new PortalContext.Request<Double>(){

                @Override
                public Double within(PortalContainer container) {
                    return StatisticsMetricHandler.applicationStatistic(container).getAverageTime(name);
                }
            });
        }
        throw new OperationFailedException(StatisticsMetricHandler.format("Unknown service statistic type '%s'. Valid values are '%s' and '%s'.", type, "site", "application"));
    }

    private static double throughput(String portal, String type, final String name) throws Exception {
        PortalContext context = new PortalContext(portal);
        if (type.equals("site")) {
            return context.execute(new PortalContext.Request<Double>(){

                @Override
                public Double within(PortalContainer container) {
                    return StatisticsMetricHandler.siteStatistic(container).getThroughput(name);
                }
            });
        }
        if (type.equals("application")) {
            throw new OperationFailedException(StatisticsMetricHandler.format("Throughput metric is not available for %s statistics.", "application"));
        }
        throw new OperationFailedException(StatisticsMetricHandler.format("Unknown service statistic type '%s'. Valid values are '%s' and '%s'.", type, "site", "application"));
    }

    private static long executionCount(String portal, String type, final String name) throws Exception {
        PortalContext context = new PortalContext(portal);
        if (type.equals("site")) {
            return context.execute(new PortalContext.Request<Long>(){

                @Override
                public Long within(PortalContainer container) {
                    return StatisticsMetricHandler.siteStatistic(container).getExecutionCount(name);
                }
            });
        }
        if (type.equals("application")) {
            return context.execute(new PortalContext.Request<Long>(){

                @Override
                public Long within(PortalContainer container) {
                    return StatisticsMetricHandler.applicationStatistic(container).getExecutionCount(name);
                }
            });
        }
        throw new OperationFailedException(StatisticsMetricHandler.format("Unknown service statistic type '%s'. Valid values are '%s' and '%s'.", type, "site", "application"));
    }

    private static PortalStatisticService siteStatistic(PortalContainer container) {
        return StatisticsMetricHandler.service(PortalStatisticService.class, container);
    }

    private static ApplicationStatisticService applicationStatistic(PortalContainer container) {
        return StatisticsMetricHandler.service(ApplicationStatisticService.class, container);
    }

    private static <T> T service(Class<T> componentType, PortalContainer container) {
        return componentType.cast(container.getComponentInstanceOfType(componentType));
    }

    private static String format(String format, Object ... args) {
        return String.format(format, args);
    }

    static enum StatisticsMetric {
        MAX_TIME("maxTime", ModelType.DOUBLE, MeasurementUnit.SECONDS),
        MIN_TIME("minTime", ModelType.DOUBLE, MeasurementUnit.SECONDS),
        AVERAGE_TIME("averageTime", ModelType.DOUBLE, MeasurementUnit.SECONDS),
        THROUGHPUT("throughput", ModelType.DOUBLE, MeasurementUnit.PER_SECOND, "site"),
        EXECUTION_COUNT("executionCount", ModelType.LONG, MeasurementUnit.NONE);

        private static final Map<String, StatisticsMetric> MAP;
        final AttributeDefinition definition;
        final String typeSpecific;

        private StatisticsMetric(String attributeName, ModelType type, MeasurementUnit measurementUnit) {
            this(attributeName, type, measurementUnit, null);
        }

        private StatisticsMetric(String attributeName, ModelType type, MeasurementUnit measurementUnit, String typeSpecific) {
            this((AttributeDefinition)new SimpleAttributeDefinitionBuilder(attributeName, type, false).setMeasurementUnit(measurementUnit).setStorageRuntime().build(), typeSpecific);
        }

        private StatisticsMetric(AttributeDefinition definition, String typeSpecific) {
            this.definition = definition;
            this.typeSpecific = typeSpecific;
        }

        static StatisticsMetric forName(String attributeName) {
            return MAP.get(attributeName);
        }

        static StatisticsMetric[] forType(String type) {
            EnumSet<StatisticsMetric> set = EnumSet.noneOf(StatisticsMetric.class);
            for (StatisticsMetric metric : StatisticsMetric.values()) {
                if (metric.typeSpecific != null && !metric.typeSpecific.equals(type)) continue;
                set.add(metric);
            }
            return set.toArray(new StatisticsMetric[set.size()]);
        }

        public String toString() {
            return this.definition.getName();
        }

        static {
            HashMap<String, StatisticsMetric> map = new HashMap<String, StatisticsMetric>();
            for (StatisticsMetric metric : StatisticsMetric.values()) {
                map.put(metric.toString(), metric);
            }
            MAP = map;
        }
    }
}

