/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.integration.jboss.as7.deployment;

import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.web.deployment.WarMetaData;
import org.jboss.metadata.web.spec.CookieConfigMetaData;
import org.jboss.metadata.web.spec.SessionConfigMetaData;
import org.jboss.metadata.web.spec.WebMetaData;

public class GateInWarStructureDeploymentProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        CookieConfigMetaData cookieConfig;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)deploymentUnit)) {
            return;
        }
        WarMetaData warMetaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        if (warMetaData == null) {
            return;
        }
        WebMetaData sharedWebMetaData = warMetaData.getSharedWebMetaData();
        if (sharedWebMetaData == null) {
            return;
        }
        SessionConfigMetaData sessionConfig = sharedWebMetaData.getSessionConfig();
        if (sessionConfig == null) {
            sessionConfig = new SessionConfigMetaData();
            warMetaData.getWebMetaData().setSessionConfig(sessionConfig);
        }
        if ((cookieConfig = sessionConfig.getCookieConfig()) == null) {
            cookieConfig = new CookieConfigMetaData();
            sessionConfig.setCookieConfig(cookieConfig);
        }
        cookieConfig.setPath("/");
    }

    public void undeploy(DeploymentUnit context) {
    }
}

