/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.integration.jboss.as7.portal;

import java.util.Locale;
import java.util.ResourceBundle;
import org.gatein.integration.jboss.as7.GateInExtension;
import org.gatein.integration.jboss.as7.portal.StatisticsMetricHandler;
import org.jboss.as.controller.descriptions.common.GlobalDescriptions;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class PortalResourceDescriptions {
    private static final String RESOURCE_NAME = GateInExtension.class.getPackage().getName() + ".LocalDescriptions";

    static ModelNode getPortalReadResourceDescription(Locale locale) {
        ModelNode node = GlobalDescriptions.getReadResourceOperationDescription((Locale)locale);
        node.get(new String[]{"reply-properties", "value-type"}).set(ModelType.OBJECT);
        return node;
    }

    static ModelNode getPortalResourceDescription(Locale locale) {
        ResourceBundle bundle = PortalResourceDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("description").set(bundle.getString("portal"));
        node.get("attributes").setEmptyObject();
        node.get("operations").setEmptyObject();
        node.get(new String[]{"children", "site", "description"}).set(bundle.getString("portal.sites"));
        node.get(new String[]{"children", "site", "model-description"});
        node.get(new String[]{"children", "application", "description"}).set(bundle.getString("portal.applications"));
        node.get(new String[]{"children", "application", "model-description"});
        return node;
    }

    static ModelNode getSiteResourceDescription(Locale locale) {
        ResourceBundle bundle = PortalResourceDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("description").set(bundle.getString("portal.site"));
        for (StatisticsMetricHandler.StatisticsMetric metric : StatisticsMetricHandler.StatisticsMetric.forType("site")) {
            metric.definition.addResourceAttributeDescription(bundle, "portal.site.metrics", node);
        }
        node.get("operations").setEmptyObject();
        node.get("children").setEmptyObject();
        return node;
    }

    static ModelNode getApplicationResourceDescription(Locale locale) {
        ResourceBundle bundle = PortalResourceDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("description").set(bundle.getString("portal.application"));
        for (StatisticsMetricHandler.StatisticsMetric metric : StatisticsMetricHandler.StatisticsMetric.forType("application")) {
            metric.definition.addResourceAttributeDescription(bundle, "portal.application.metrics", node);
        }
        node.get("operations").setEmptyObject();
        node.get("children").setEmptyObject();
        return node;
    }

    protected static ResourceBundle getResourceBundle(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(RESOURCE_NAME, locale);
    }
}

