/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.integration.jboss.as7.deployment;

import java.util.ArrayList;
import java.util.ListIterator;
import java.util.Map;
import org.gatein.cdi.contexts.listeners.CDIServletListener;
import org.gatein.integration.jboss.as7.GateInConfiguration;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.web.deployment.WarMetaData;
import org.jboss.as.web.deployment.WebAttachments;
import org.jboss.as.web.deployment.component.WebComponentDescription;
import org.jboss.as.web.deployment.component.WebComponentInstantiator;
import org.jboss.as.weld.WeldDeploymentMarker;
import org.jboss.logging.Logger;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.ListenerMetaData;

public class CdiWebIntegrationProcessor
implements DeploymentUnitProcessor {
    private static final Logger log = Logger.getLogger(CdiWebIntegrationProcessor.class);
    private static final String CDI_LISTENER = CDIServletListener.class.getName();
    private final ListenerMetaData cdiListener = new ListenerMetaData();

    public CdiWebIntegrationProcessor() {
        this.cdiListener.setListenerClass(CDI_LISTENER);
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEModuleDescription module = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        EEApplicationClasses applicationClasses = (EEApplicationClasses)deploymentUnit.getAttachment(Attachments.EE_APPLICATION_CLASSES_DESCRIPTION);
        if (!GateInConfiguration.isPortletArchive(deploymentUnit)) {
            return;
        }
        if (!WeldDeploymentMarker.isPartOfWeldDeployment((DeploymentUnit)deploymentUnit)) {
            return;
        }
        WarMetaData warMetaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        if (warMetaData == null) {
            log.debug((Object)"Not installing GateIn CDI web tier integration as no war metadata found");
            return;
        }
        JBossWebMetaData webMetaData = warMetaData.getMergedJBossWebMetaData();
        if (webMetaData == null) {
            log.debug((Object)"Not installing GateIn CDI web tier integration as no merged web metadata found");
            return;
        }
        ArrayList<ListenerMetaData> listeners = webMetaData.getListeners();
        if (listeners == null) {
            listeners = new ArrayList<ListenerMetaData>();
            webMetaData.setListeners(listeners);
        } else {
            ListIterator iterator = listeners.listIterator();
            while (iterator.hasNext()) {
                ListenerMetaData listener = (ListenerMetaData)iterator.next();
                if (!listener.getListenerClass().trim().equals(CDI_LISTENER)) continue;
                log.debugf("Removing cdi servlet listener %s from web config, as it is not needed in EE6 environments", (Object)CDI_LISTENER);
                iterator.remove();
                break;
            }
        }
        listeners.add(0, this.cdiListener);
        WebComponentDescription componentDescription = new WebComponentDescription(CDI_LISTENER, CDI_LISTENER, module, deploymentUnit.getServiceName(), applicationClasses);
        module.addComponent((ComponentDescription)componentDescription);
        Map instantiators = (Map)deploymentUnit.getAttachment(WebAttachments.WEB_COMPONENT_INSTANTIATORS);
        instantiators.put(CDI_LISTENER, new WebComponentInstantiator(deploymentUnit, (ComponentDescription)componentDescription));
    }

    public void undeploy(DeploymentUnit context) {
    }
}

